/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.byShard.calculators;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.AllMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric.temperature.TemperatureMetricsBase;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectSeekStep1;
import org.jooq.impl.DSL;

public class ShardBasedTemperatureCalculator
extends TemperatureMetricsBase {
    private static final String[] dimensions = new String[]{AllMetrics.CommonDimension.INDEX_NAME.toString(), AllMetrics.CommonDimension.SHARD_ID.toString()};

    public ShardBasedTemperatureCalculator(TemperatureDimension metricType) {
        super(metricType, dimensions);
    }

    protected SelectSeekStep1<Record, ?> getSumOfUtilByIndexShardGroup(DSLContext context, String tableName, Field<?> aggDimension, List<Field<?>> groupByFieldsList, List<Field<?>> selectFieldsList) {
        Field shardIdField = DSL.field((Name)DSL.name((String)AllMetrics.CommonDimension.SHARD_ID.toString()));
        return context.select(selectFieldsList).from(tableName).where(new Condition[]{shardIdField.isNotNull()}).groupBy(groupByFieldsList).orderBy((OrderField)aggDimension.desc());
    }

    @Override
    protected Result<Record> createDslAndFetch(DSLContext context, String tableName, Field<?> aggDimension, List<Field<?>> groupByFieldsList, List<Field<?>> selectFieldsList) {
        return this.getSumOfUtilByIndexShardGroup(context, tableName, aggDimension, groupByFieldsList, selectFieldsList).fetch();
    }
}

