/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.metric;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.metricsdb.MetricsDB;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Metric;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.Queryable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.impl.DSL;

public class AggregateMetric
extends Metric {
    private static final Logger LOG = LogManager.getLogger(AggregateMetric.class);
    private final String tableName;
    private final List<String> groupByFieldsName;
    private final AggregateFunction aggregateFunction;
    private final String metricsDBAggrColumn;

    public AggregateMetric(long evaluationIntervalSeconds, String tableName, AggregateFunction aggregateFunction, String metricsDBCol, String ... groupByFieldsName) {
        super("", evaluationIntervalSeconds);
        this.tableName = tableName;
        this.groupByFieldsName = new ArrayList<String>(Arrays.asList(groupByFieldsName));
        this.aggregateFunction = aggregateFunction;
        switch (metricsDBCol) {
            case "sum": 
            case "avg": 
            case "min": 
            case "max": {
                this.metricsDBAggrColumn = metricsDBCol;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized metricsDB col: " + metricsDBCol);
            }
        }
    }

    protected Result<Record> createDslAndFetch(DSLContext context, String tableName, Field<?> aggDimension, List<Field<?>> groupByFieldsList, List<Field<?>> selectFieldsList) {
        return context.select(selectFieldsList).from(tableName).groupBy(groupByFieldsList).orderBy((OrderField)aggDimension.desc()).fetch();
    }

    protected List<Field<?>> getGroupByFieldsList() {
        if (this.groupByFieldsName.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList groupByFieldsList = new ArrayList();
        this.groupByFieldsName.forEach(f -> groupByFieldsList.add(DSL.field((Name)DSL.name((String)f))));
        return groupByFieldsList;
    }

    protected List<Field<?>> getSelectFieldsList(List<Field<?>> groupByFields, Field<?> aggrDimension) {
        ArrayList fieldsList = new ArrayList(groupByFields);
        fieldsList.add(aggrDimension);
        return fieldsList;
    }

    protected Field<?> getAggrDimension() {
        Field numDimension = DSL.field((Name)DSL.name((String)this.metricsDBAggrColumn), Double.class);
        return AggregateMetric.getAggDimension((Field<Double>)numDimension, this.aggregateFunction);
    }

    @Override
    public MetricFlowUnit gather(Queryable queryable) {
        Result<Record> result;
        LOG.debug("Metric: Trying to gather metrics for {}", (Object)this.tableName);
        try {
            MetricsDB db = queryable.getMetricsDB();
            DSLContext context = db.getDSLContext();
            Field<?> aggDimension = this.getAggrDimension();
            List<Field<?>> groupByFieldsList = this.getGroupByFieldsList();
            List<Field<?>> selectFieldsList = this.getSelectFieldsList(groupByFieldsList, aggDimension);
            result = this.createDslAndFetch(context, this.tableName, aggDimension, groupByFieldsList, selectFieldsList);
        }
        catch (Exception e) {
            LOG.error("RCA: Caught an exception while getting the DB {}", (Object)e.getMessage());
            return MetricFlowUnit.generic();
        }
        return new MetricFlowUnit(0L, result);
    }

    protected static Field<?> getAggDimension(Field<Double> numDimension, AggregateFunction aggregateFunction) {
        if (aggregateFunction == AggregateFunction.MAX) {
            return DSL.max(numDimension);
        }
        if (aggregateFunction == AggregateFunction.MIN) {
            return DSL.min(numDimension);
        }
        if (aggregateFunction == AggregateFunction.AVG) {
            return DSL.avg(numDimension);
        }
        return DSL.sum(numDimension);
    }

    public static enum AggregateFunction {
        SUM,
        MAX,
        MIN,
        AVG;

    }
}

