/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.collector;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.EmptyFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.NodeConfigFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.collector.NodeConfigCache;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.collector.NodeConfigCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeConfigClusterCollector
extends NonLeafNode<EmptyFlowUnit> {
    private static final Logger LOG = LogManager.getLogger(NodeConfigClusterCollector.class);
    private final NodeConfigCollector nodeConfigCollector;

    public NodeConfigClusterCollector(NodeConfigCollector nodeConfigCollector) {
        super(0, 5L);
        this.nodeConfigCollector = nodeConfigCollector;
    }

    private void addNodeLevelConfigs() {
        List flowUnits = this.nodeConfigCollector.getFlowUnits();
        for (NodeConfigFlowUnit flowUnit : flowUnits) {
            if (flowUnit.isEmpty() || !flowUnit.hasResourceSummary()) continue;
            HotNodeSummary nodeSummary = (HotNodeSummary)flowUnit.getSummary();
            NodeKey nodeKey = new NodeKey(nodeSummary.getNodeID(), nodeSummary.getHostAddress());
            NodeConfigCache nodeConfigCache = this.getAppContext().getNodeConfigCache();
            flowUnit.getConfigList().forEach(resource -> {
                double value = flowUnit.readConfig((Resource)resource);
                if (!Double.isNaN(value)) {
                    nodeConfigCache.put(nodeKey, (Resource)resource, value);
                }
            });
        }
    }

    @Override
    public EmptyFlowUnit operate() {
        this.addNodeLevelConfigs();
        return new EmptyFlowUnit(System.currentTimeMillis());
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        LOG.debug("Collector: Executing fromLocal: {}", (Object)this.name());
        long startTime = System.currentTimeMillis();
        try {
            this.operate();
        }
        catch (Exception ex) {
            LOG.error("Collector: Exception in operate", (Throwable)ex);
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_OPERATE, this.name(), 1);
        }
        long duration = System.currentTimeMillis() - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), duration);
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void handleNodeMuted() {
    }
}

