/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.format;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.Statistics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.impl.vals.AggregateValue;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.impl.vals.NamedAggregateValue;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.impl.vals.Value;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.format.Formatter;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultFormatter
implements Formatter {
    private Map<MeasurementSet, Map<Statistics, List<Value>>> map = new HashMap<MeasurementSet, Map<Statistics, List<Value>>>();
    private long start = 0L;
    private long end = 0L;

    @Override
    public void formatNamedAggregatedValue(MeasurementSet measurementSet, Statistics aggregationType, String name, Number value) {
        this.map.putIfAbsent(measurementSet, new HashMap());
        this.map.get(measurementSet).putIfAbsent(aggregationType, new ArrayList());
        this.map.get(measurementSet).get((Object)aggregationType).add(new NamedAggregateValue(value, aggregationType, name));
    }

    @Override
    public void formatAggregatedValue(MeasurementSet measurementSet, Statistics aggregationType, Number value) {
        this.map.putIfAbsent(measurementSet, new HashMap());
        Value value1 = aggregationType == Statistics.SAMPLE ? new Value(value) : new AggregateValue(value, aggregationType);
        this.map.get(measurementSet).put(aggregationType, Collections.singletonList(value1));
    }

    @Override
    public void setStartAndEndTime(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public Map<MeasurementSet, Map<Statistics, List<Value>>> getFormatted() {
        return this.map;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }
}

