/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.impl;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.Statistics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.impl.IStatistic;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.impl.vals.NamedAggregateValue;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NamedCounter
implements IStatistic<NamedAggregateValue> {
    private boolean empty = true;
    private Map<String, NamedAggregateValue> counters = new ConcurrentHashMap<String, NamedAggregateValue>();

    @Override
    public Statistics type() {
        return Statistics.NAMED_COUNTERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculate(String key, Number value) {
        NamedCounter namedCounter = this;
        synchronized (namedCounter) {
            NamedAggregateValue mapValue = this.counters.getOrDefault(key, new NamedAggregateValue(0L, Statistics.NAMED_COUNTERS, key));
            try {
                Number numb = mapValue.getValue();
                long number = mapValue.getValue().longValue();
                long newNumber = number + 1L;
                mapValue.update(newNumber);
                this.counters.put(key, mapValue);
                this.empty = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Collection<NamedAggregateValue> get() {
        return this.counters.values();
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }
}

