/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.samplers;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.collectors.SampleAggregator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.emitters.ISampler;
import java.util.Objects;

public class RcaEnabledSampler
implements ISampler {
    private final AppContext appContext;

    RcaEnabledSampler(AppContext appContext) {
        Objects.requireNonNull(appContext);
        this.appContext = appContext;
    }

    @Override
    public void sample(SampleAggregator sampleCollector) {
        sampleCollector.updateStat(RcaRuntimeMetrics.RCA_ENABLED, "", this.isRcaEnabled() ? 1 : 0);
    }

    boolean isRcaEnabled() {
        InstanceDetails currentNode = this.appContext.getMyInstanceDetails();
        if (currentNode != null && currentNode.getIsMaster()) {
            return PerformanceAnalyzerApp.getRcaController().isRcaEnabled();
        }
        return false;
    }
}

