/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.response;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.GenericSummary;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;

public class RcaResponse
extends GenericSummary {
    private static final Logger LOG = LogManager.getLogger(RcaResponse.class);
    private String rcaName;
    private String state;
    private long timeStamp;
    List<GenericSummary> summaryList;

    public RcaResponse(String rcaName, String state, long timeStamp) {
        this.rcaName = rcaName;
        this.state = state;
        this.timeStamp = timeStamp;
        this.summaryList = new ArrayList<GenericSummary>();
    }

    public String getRcaName() {
        return this.rcaName;
    }

    public String getState() {
        return this.state;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public static RcaResponse buildResponse(Record record) {
        RcaResponse response = null;
        try {
            String rcaName = (String)record.get(ResourceFlowUnit.ResourceFlowUnitFieldValue.RCA_NAME_FILELD.getField(), String.class);
            String state = (String)record.get(ResourceFlowUnit.ResourceFlowUnitFieldValue.STATE_NAME_FILELD.getField(), String.class);
            Long timeStamp = (Long)record.get(ResourceFlowUnit.ResourceFlowUnitFieldValue.TIMESTAMP_FIELD.getField(), Long.class);
            response = new RcaResponse(rcaName, state, timeStamp);
        }
        catch (IllegalArgumentException ie) {
            LOG.error("Some field is not found in record, cause : {}", (Object)ie.getMessage());
        }
        catch (DataTypeException de) {
            LOG.error("Fails to convert data type");
        }
        catch (NullPointerException ne) {
            LOG.error("read null object from SQL, trace : {} ", (Object[])ne.getStackTrace());
        }
        return response;
    }

    public GeneratedMessageV3 buildSummaryMessage() {
        return null;
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
    }

    @Override
    public String getTableName() {
        return "RCA";
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        return null;
    }

    @Override
    public List<Object> getSqlValue() {
        return null;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty("rca_name", this.rcaName);
        summaryObj.addProperty("timestamp", (Number)this.timeStamp);
        summaryObj.addProperty("state", this.state);
        if (!this.getNestedSummaryList().isEmpty()) {
            String tableName = this.getNestedSummaryList().get(0).getTableName();
            summaryObj.add(tableName, (JsonElement)this.nestedSummaryListToJson());
        }
        return summaryObj;
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        return this.summaryList;
    }

    @Override
    public GenericSummary buildNestedSummary(String summaryTable, Record record) {
        HotClusterSummary hotClusterSummary;
        HotClusterSummary ret = null;
        if (summaryTable.equals(HotClusterSummary.HOT_CLUSTER_SUMMARY_TABLE) && (hotClusterSummary = HotClusterSummary.buildSummary(record)) != null) {
            this.summaryList.add(hotClusterSummary);
            ret = hotClusterSummary;
        }
        return ret;
    }

    @Override
    public List<String> getNestedSummaryTables() {
        return Collections.unmodifiableList(Collections.singletonList(HotClusterSummary.HOT_CLUSTER_SUMMARY_TABLE));
    }

    public void addNestedSummaryList(GenericSummary summary) {
        this.summaryList.add(summary);
    }
}

