/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.pyrometer;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.ShardProfileSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.HeatZoneAssigner;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class Api {
    private static boolean checkIfElectedMaster() {
        return true;
    }

    private static void failIfNotElectedMaster(String apiName) {
        if (!Api.checkIfElectedMaster()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Api (").append(apiName).append(") can only be called from the elected master node.");
            throw new IllegalStateException(builder.toString());
        }
    }

    public static boolean isClusterImbalanceAlongDimension(TemperatureDimension dimension) {
        Api.failIfNotElectedMaster("getClusterImbalanceAlongDimension");
        return true;
    }

    @Nonnull
    public static List<CompactNodeSummary> getNodesForGivenZone(TemperatureDimension dimension, HeatZoneAssigner.Zone zone, Count count, SortOrder order) {
        Api.failIfNotElectedMaster("getNodes");
        return new ArrayList<CompactNodeSummary>();
    }

    @Nonnull
    public static Map<HeatZoneAssigner.Zone, List<CompactNodeSummary>> getNodesForAllZones(TemperatureDimension dimension, Count count, SortOrder order) {
        Api.failIfNotElectedMaster("getNodes");
        HashMap<HeatZoneAssigner.Zone, List<CompactNodeSummary>> nodes = new HashMap<HeatZoneAssigner.Zone, List<CompactNodeSummary>>();
        for (HeatZoneAssigner.Zone zone : HeatZoneAssigner.Zone.values()) {
            nodes.put(zone, Api.getNodesForGivenZone(dimension, zone, count, order));
        }
        return nodes;
    }

    @Nonnull
    public static List<ShardProfileSummary> getShards(CompactNodeSummary node, TemperatureDimension dimension, HeatZoneAssigner.Zone zone, Count count, SortOrder sortOrder) {
        ArrayList<ShardProfileSummary> shards = new ArrayList<ShardProfileSummary>();
        return shards;
    }

    static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    static enum Count {
        ALL,
        TOP_K;

    }
}

