/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.persistence;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.exceptions.MalformedConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.RcaConsts;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.persistence.Persistable;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.persistence.SQLitePersistor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public class PersistenceFactory {
    public static Persistable create(RcaConf rcaConf) throws MalformedConfig, SQLException, IOException {
        Map<String, String> datastore = rcaConf.getDatastore();
        switch (datastore.get("type").toLowerCase()) {
            case "sqlite": {
                return new SQLitePersistor(datastore.get("location-dir"), datastore.get("filename"), datastore.get("storage-file-retention-count"), RcaConsts.DB_FILE_ROTATION_TIME_UNIT, 1L);
            }
        }
        String err = "The datastore value can only be sqlite in any case format";
        throw new MalformedConfig(rcaConf.getConfigFileLoc(), err);
    }
}

