/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.tasks;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.net.NetClient;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.messages.UnicastIntentMsg;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.NodeStateManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.SubscriptionManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.tasks.SubscriptionTxTask;
import java.util.Map;

public class UnicastSubscriptionTxTask
extends SubscriptionTxTask {
    private final InstanceDetails destinationInstance;

    public UnicastSubscriptionTxTask(NetClient netClient, UnicastIntentMsg intentMsg, SubscriptionManager subscriptionManager, NodeStateManager nodeStateManager, AppContext appContext) {
        super(netClient, intentMsg, subscriptionManager, nodeStateManager, appContext);
        this.destinationInstance = intentMsg.getUnicastDestinationInstance();
    }

    @Override
    public void run() {
        String requesterVertex = this.intentMsg.getRequesterGraphNode();
        String destinationVertex = this.intentMsg.getDestinationGraphNode();
        Map<String, String> tags = this.intentMsg.getRcaConfTags();
        this.sendSubscribeRequest(this.destinationInstance, requesterVertex, destinationVertex, tags);
    }
}

