/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.tasks;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.SubscribeMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.net.NetClient;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.messages.IntentMsg;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.NodeStateManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.SubscribeResponseHandler;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.SubscriptionManager;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SubscriptionTxTask
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(SubscriptionTxTask.class);
    protected final NetClient netClient;
    protected final IntentMsg intentMsg;
    protected final SubscriptionManager subscriptionManager;
    protected final NodeStateManager nodeStateManager;
    private final AppContext appContext;

    public SubscriptionTxTask(NetClient netClient, IntentMsg intentMsg, SubscriptionManager subscriptionManager, NodeStateManager nodeStateManager, AppContext appContext) {
        this.netClient = netClient;
        this.intentMsg = intentMsg;
        this.subscriptionManager = subscriptionManager;
        this.nodeStateManager = nodeStateManager;
        this.appContext = appContext;
    }

    protected void sendSubscribeRequest(InstanceDetails remoteHost, String requesterVertex, String destinationVertex, Map<String, String> tags) {
        LOG.debug("rca: [sub-tx]: {} -> {} to {}", (Object)requesterVertex, (Object)destinationVertex, (Object)remoteHost);
        SubscribeMessage subscribeMessage = SubscribeMessage.newBuilder().setDestinationGraphNode(destinationVertex).setRequesterGraphNode(requesterVertex).putTags("locus", tags.get("locus")).putTags("requester", this.appContext.getMyInstanceDetails().getInstanceId().toString()).build();
        this.netClient.subscribe(remoteHost, subscribeMessage, new SubscribeResponseHandler(this.subscriptionManager, this.nodeStateManager, remoteHost, destinationVertex));
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.RCA_NODES_SUB_REQ_COUNT, requesterVertex + ":" + destinationVertex, 1);
    }

    protected Set<InstanceDetails> getPeerInstances() {
        return this.appContext.getPeerInstances();
    }
}

