/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.tasks;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.SubscribeMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.SubscribeResponse;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.SubscriptionManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.requests.CompositeSubscribeRequest;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubscriptionRxTask
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(SubscriptionRxTask.class);
    private final SubscriptionManager subscriptionManager;
    private final CompositeSubscribeRequest compositeSubscribeRequest;

    public SubscriptionRxTask(SubscriptionManager subscriptionManager, CompositeSubscribeRequest compositeSubscribeRequest) {
        this.subscriptionManager = subscriptionManager;
        this.compositeSubscribeRequest = compositeSubscribeRequest;
    }

    @Override
    public void run() {
        SubscribeMessage request = this.compositeSubscribeRequest.getSubscribeMessage();
        Map<String, String> tags = request.getTagsMap();
        InstanceDetails.Id requesterHostId = new InstanceDetails.Id(tags.getOrDefault("requester", ""));
        String locus = tags.getOrDefault("locus", "");
        SubscribeResponse.SubscriptionStatus subscriptionStatus = this.subscriptionManager.addSubscriber(request.getDestinationGraphNode(), requesterHostId, locus);
        LOG.debug("rca: [sub-rx]: {} <- {} from {} Result: {}", (Object)request.getDestinationGraphNode(), (Object)request.getRequesterGraphNode(), (Object)requesterHostId, (Object)subscriptionStatus);
        StreamObserver<SubscribeResponse> responseStream = this.compositeSubscribeRequest.getSubscribeResponseStream();
        responseStream.onNext((Object)SubscribeResponse.newBuilder().setSubscriptionStatus(subscriptionStatus).build());
        responseStream.onCompleted();
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.RCA_NODES_SUB_ACK_COUNT, request.getRequesterGraphNode() + ":" + request.getDestinationGraphNode(), 1);
    }
}

