/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.tasks;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.NodeStateManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.ReceivedFlowUnitStore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowUnitRxTask
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(FlowUnitRxTask.class);
    private final NodeStateManager nodeStateManager;
    private final ReceivedFlowUnitStore receivedFlowUnitStore;
    private final FlowUnitMessage flowUnitMessage;

    public FlowUnitRxTask(NodeStateManager nodeStateManager, ReceivedFlowUnitStore receivedFlowUnitStore, FlowUnitMessage flowUnitMessage) {
        this.nodeStateManager = nodeStateManager;
        this.receivedFlowUnitStore = receivedFlowUnitStore;
        this.flowUnitMessage = flowUnitMessage;
    }

    @Override
    public void run() {
        InstanceDetails.Id host = new InstanceDetails.Id(this.flowUnitMessage.getEsNode());
        String vertex = this.flowUnitMessage.getGraphNode();
        this.nodeStateManager.updateReceiveTime(host, vertex, System.currentTimeMillis());
        LOG.debug("rca: [pub-rx]: {} <- {}", (Object)vertex, (Object)host);
        if (!this.receivedFlowUnitStore.enqueue(vertex, this.flowUnitMessage)) {
            LOG.warn("Dropped a flow unit because the vertex buffer was full for vertex: {}", (Object)vertex);
            StatsCollector.instance().logMetric("RcaVertexBufferFull");
        }
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.RCA_NODES_FU_CONSUME_COUNT, vertex, 1);
    }
}

