/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.SubscribeResponse;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.net.GRPCConnectionManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubscriptionManager {
    private static final Logger LOG = LogManager.getLogger(SubscriptionManager.class);
    private final GRPCConnectionManager connectionManager;
    private final ConcurrentMap<String, Set<InstanceDetails.Id>> publisherMap = new ConcurrentHashMap<String, Set<InstanceDetails.Id>>();
    private final ConcurrentMap<String, Set<InstanceDetails.Id>> subscriberMap = new ConcurrentHashMap<String, Set<InstanceDetails.Id>>();
    private volatile String currentLocus;

    public SubscriptionManager(GRPCConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void unsubscribeAndTerminateConnection(String graphNode, InstanceDetails.Id remoteHost) {
        LOG.debug("Unsubscribing {} from {} updates", (Object)remoteHost, (Object)graphNode);
        if (this.subscriberMap.containsKey(graphNode)) {
            Set subscribers = (Set)this.subscriberMap.get(graphNode);
            subscribers.remove(remoteHost);
            if (subscribers.size() > 0) {
                this.subscriberMap.put(graphNode, subscribers);
            } else {
                this.subscriberMap.remove(graphNode);
            }
        }
        this.connectionManager.terminateConnection(remoteHost);
    }

    public synchronized SubscribeResponse.SubscriptionStatus addSubscriber(String graphNode, InstanceDetails.Id subscriberHostId, String loci) {
        List<String> vertexLoci = Arrays.asList(loci.split(","));
        if (!vertexLoci.contains(this.currentLocus)) {
            LOG.debug("locus mismatch. Rejecting subscription. Req: {}, Curr: {}", (Object)loci, (Object)this.currentLocus);
            return SubscribeResponse.SubscriptionStatus.TAG_MISMATCH;
        }
        Set currentSubscribers = this.subscriberMap.getOrDefault(graphNode, new HashSet());
        currentSubscribers.add(subscriberHostId);
        this.subscriberMap.put(graphNode, currentSubscribers);
        LOG.debug("locus matched. Added subscriber {} for {}", (Object)subscriberHostId, (Object)graphNode);
        return SubscribeResponse.SubscriptionStatus.SUCCESS;
    }

    public boolean isNodeSubscribed(String graphNode) {
        return this.subscriberMap.containsKey(graphNode);
    }

    public ImmutableSet<InstanceDetails.Id> getSubscribersFor(String graphNode) {
        return ImmutableSet.copyOf((Collection)this.subscriberMap.getOrDefault(graphNode, new HashSet()));
    }

    public synchronized void addPublisher(String graphNode, InstanceDetails.Id publisherHostId) {
        LOG.info("Added publisher: {} for graphNode: {}", (Object)publisherHostId, (Object)graphNode);
        Set currentPublishers = this.publisherMap.getOrDefault(graphNode, new HashSet());
        currentPublishers.add(publisherHostId);
        this.publisherMap.put(graphNode, currentPublishers);
    }

    public void setCurrentLocus(String currentLocus) {
        this.currentLocus = currentLocus;
    }

    public Set<InstanceDetails.Id> getPublishersForNode(String graphNode) {
        return this.publisherMap.getOrDefault(graphNode, Collections.emptySet());
    }
}

