/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.SubscribeResponse;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.NodeStateManager;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net.SubscriptionManager;
import io.grpc.stub.StreamObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubscribeResponseHandler
implements StreamObserver<SubscribeResponse> {
    private static final Logger LOG = LogManager.getLogger(SubscribeResponseHandler.class);
    private final SubscriptionManager subscriptionManager;
    private final NodeStateManager nodeStateManager;
    private final InstanceDetails.Id remoteHostId;
    private final String graphNode;

    public SubscribeResponseHandler(SubscriptionManager subscriptionManager, NodeStateManager nodeStateManager, InstanceDetails remoteHost, String graphNode) {
        this.subscriptionManager = subscriptionManager;
        this.nodeStateManager = nodeStateManager;
        this.graphNode = graphNode;
        this.remoteHostId = remoteHost.getInstanceId();
    }

    public void onNext(SubscribeResponse subscribeResponse) {
        if (subscribeResponse.getSubscriptionStatus() == SubscribeResponse.SubscriptionStatus.SUCCESS) {
            this.subscriptionManager.addPublisher(this.graphNode, this.remoteHostId);
            this.nodeStateManager.updateSubscriptionState(this.graphNode, this.remoteHostId, SubscribeResponse.SubscriptionStatus.SUCCESS);
        } else if (subscribeResponse.getSubscriptionStatus() == SubscribeResponse.SubscriptionStatus.TAG_MISMATCH) {
            this.nodeStateManager.updateSubscriptionState(this.graphNode, this.remoteHostId, SubscribeResponse.SubscriptionStatus.TAG_MISMATCH);
        }
    }

    public void onError(Throwable t) {
        LOG.error("Encountered an error while processing subscription stream", t);
    }

    public void onCompleted() {
        LOG.info("Finished subscription request for {}. Closing stream.", (Object)this.remoteHostId);
    }
}

