/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReceivedFlowUnitStore {
    private static final Logger LOG = LogManager.getLogger(ReceivedFlowUnitStore.class);
    private ConcurrentMap<String, BlockingQueue<FlowUnitMessage>> flowUnitMap = new ConcurrentHashMap<String, BlockingQueue<FlowUnitMessage>>();
    private final int perNodeFlowUnitQSize;

    public ReceivedFlowUnitStore() {
        this(200);
    }

    public ReceivedFlowUnitStore(int perNodeFlowUnitQSize) {
        this.perNodeFlowUnitQSize = perNodeFlowUnitQSize;
    }

    public boolean enqueue(String graphNode, FlowUnitMessage flowUnitMessage) {
        this.flowUnitMap.computeIfAbsent(graphNode, s -> new ArrayBlockingQueue(this.perNodeFlowUnitQSize));
        BlockingQueue existingQueue = (BlockingQueue)this.flowUnitMap.get(graphNode);
        boolean retValue = existingQueue.offer(flowUnitMessage);
        if (!retValue) {
            LOG.warn("Dropped flow unit because per vertex queue is full");
            StatsCollector.instance().logException(StatExceptionCode.RCA_VERTEX_RX_BUFFER_FULL_ERROR);
        }
        return retValue;
    }

    public ImmutableList<FlowUnitMessage> drainNode(String graphNode) {
        ArrayList tempList = new ArrayList();
        BlockingQueue existing = (BlockingQueue)this.flowUnitMap.get(graphNode);
        if (existing == null) {
            return ImmutableList.of();
        }
        existing.drainTo(tempList);
        return ImmutableList.copyOf(tempList);
    }

    public List<FlowUnitMessage> drainAll() {
        ArrayList<FlowUnitMessage> drained = new ArrayList<FlowUnitMessage>();
        for (String graphNode : this.flowUnitMap.keySet()) {
            ImmutableList<FlowUnitMessage> messages = this.drainNode(graphNode);
            drained.addAll((Collection<FlowUnitMessage>)messages);
        }
        return drained;
    }
}

