/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.net;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.SubscribeResponse;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.util.ClusterUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class NodeStateManager {
    private static final String SEPARATOR = ".";
    private final ConcurrentMap<String, Long> lastReceivedTimestampMap = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, AtomicReference<SubscribeResponse.SubscriptionStatus>> subscriptionStatusMap = new ConcurrentHashMap<String, AtomicReference<SubscribeResponse.SubscriptionStatus>>();
    private final AppContext appContext;

    public NodeStateManager(AppContext appContext) {
        this.appContext = appContext;
    }

    public void updateReceiveTime(InstanceDetails.Id host, String graphNode, long timestamp) {
        String compositeKey = graphNode + SEPARATOR + host;
        this.lastReceivedTimestampMap.put(compositeKey, timestamp);
    }

    public long getLastReceivedTimestamp(String graphNode, InstanceDetails.Id host) {
        String compositeKey = graphNode + SEPARATOR + host;
        return this.lastReceivedTimestampMap.getOrDefault(compositeKey, 0L);
    }

    @VisibleForTesting
    SubscribeResponse.SubscriptionStatus getSubscriptionStatus(String graphNode, InstanceDetails.Id host) {
        String compositeKey = graphNode + SEPARATOR + host;
        AtomicReference ref = (AtomicReference)this.subscriptionStatusMap.get(compositeKey);
        if (ref == null) {
            return null;
        }
        return (SubscribeResponse.SubscriptionStatus)((Object)ref.get());
    }

    public synchronized void updateSubscriptionState(String graphNode, InstanceDetails.Id host, SubscribeResponse.SubscriptionStatus status) {
        String compositeKey = graphNode + SEPARATOR + host;
        this.subscriptionStatusMap.putIfAbsent(compositeKey, new AtomicReference());
        ((AtomicReference)this.subscriptionStatusMap.get(compositeKey)).set(status);
    }

    public ImmutableList<InstanceDetails> getStaleOrNotSubscribedNodes(String graphNode, long maxIdleDuration, Set<InstanceDetails.Id> publishers) {
        long currentTime = System.currentTimeMillis();
        HashSet<InstanceDetails> hostsToSubscribeTo = new HashSet<InstanceDetails>();
        for (InstanceDetails.Id publisher : publishers) {
            long lastRxTimestamp = this.getLastReceivedTimestamp(graphNode, publisher);
            if (lastRxTimestamp <= 0L || currentTime - lastRxTimestamp <= maxIdleDuration || !ClusterUtils.isHostIdInCluster(publisher, this.appContext.getAllClusterInstances())) continue;
            hostsToSubscribeTo.add(this.appContext.getInstanceById(publisher));
        }
        Set<InstanceDetails> peers = this.appContext.getPeerInstances();
        if (peers != null) {
            for (InstanceDetails peerHost : peers) {
                String compositeKey = graphNode + SEPARATOR + peerHost.getInstanceId();
                if (this.subscriptionStatusMap.containsKey(compositeKey)) continue;
                hostsToSubscribeTo.add(peerHost);
            }
        }
        return ImmutableList.copyOf(hostsToSubscribeTo);
    }

    @VisibleForTesting
    public AppContext getAppContext() {
        return this.appContext;
    }
}

