/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.Statistics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import java.util.Collections;
import java.util.List;

public enum RcaRuntimeMetrics implements MeasurementSet
{
    RCA_STOPPED_BY_OPERATOR("RcaStoppedByOperator", "count", Collections.singletonList(Statistics.COUNT)),
    RCA_RESTARTED_BY_OPERATOR("RcaRestartedByOperator", "count", Collections.singletonList(Statistics.COUNT)),
    ES_APIS_CALLED("ESApisCalled", "count", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_ENABLED("RcaEnabled", "count", Collections.singletonList(Statistics.SAMPLE)),
    NO_INCREASE_ACTION_SUGGESTED("NoIncreaseAction", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    ACTIONS_PUBLISHED("ActionsPublished", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS));

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private RcaRuntimeMetrics(String name, String unit, List<Statistics> statisticList) {
        this.name = name;
        this.unit = unit;
        this.statsList = statisticList;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

