/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.Statistics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum RcaGraphMetrics implements MeasurementSet
{
    GRAPH_EXECUTION_TIME("RcaGraphExecution", "millis", Arrays.asList(Statistics.MAX, Statistics.MIN, Statistics.MEAN, Statistics.COUNT, Statistics.SUM)),
    GRAPH_NODE_OPERATE_CALL("OperateCall", "millis", Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    METRIC_GATHER_CALL("MetricGatherCall", "millis", Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    RCA_PERSIST_CALL("RcaPersistCall", "micros", Arrays.asList(Statistics.MAX, Statistics.MEAN, Statistics.SUM)),
    NUM_GRAPH_NODES("NumGraphNodes", "count", Collections.singletonList(Statistics.SAMPLE)),
    NUM_GRAPH_NODES_MUTED("NUMOfMutedGraphNodes", "count", Collections.singletonList(Statistics.SAMPLE)),
    NUM_NODES_EXECUTED_LOCALLY("NodesExecutedLocally", "count", Collections.singletonList(Statistics.COUNT)),
    NUM_NODES_EXECUTED_REMOTELY("NodesExecutedRemotely", "count", Collections.singletonList(Statistics.COUNT)),
    NET_BYTES_OUT("TotalRcaBytesOutSerialized", "bytes", Collections.singletonList(Statistics.SUM)),
    NET_BYTES_IN("TotalRcaBytesInSerialized", "bytes", Collections.singletonList(Statistics.SUM)),
    RCA_NODES_FU_PUBLISH_COUNT("RcaFlowUnitPublishCount", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_NODES_FU_CONSUME_COUNT("RcaFlowUnitConsumeCount", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_NODES_SUB_REQ_COUNT("RcaSubscriptionRequestCount", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS)),
    RCA_NODES_SUB_ACK_COUNT("RcaSubscriptionAckCount", "namedCount", Collections.singletonList(Statistics.NAMED_COUNTERS));

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private RcaGraphMetrics(String name, String unit, List<Statistics> statisticList) {
        this.name = name;
        this.unit = unit;
        this.statsList = statisticList;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

