/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.Statistics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import java.util.Collections;
import java.util.List;

public enum ExceptionsAndErrors implements MeasurementSet
{
    RCA_FRAMEWORK_CRASH("RcaFrameworkCrash"),
    EXCEPTION_IN_OPERATE("ExceptionInOperate", "namedCount", Statistics.NAMED_COUNTERS),
    EXCEPTION_IN_COMPUTE("ExceptionInCompute", "namedCount", Statistics.NAMED_COUNTERS),
    EXCEPTION_IN_GATHER("ExceptionInGather", "namedCount", Statistics.NAMED_COUNTERS),
    EXCEPTION_IN_PERSIST("ExceptionInPersist", "namedCount", Statistics.NAMED_COUNTERS),
    READER_METRICSDB_ACCESS_ERRORS("ReaderMetricsdbAccessError"),
    SHARD_STATE_COLLECTOR_ERROR("ShardStateCollectorError"),
    MASTER_THROTTLING_COLLECTOR_ERROR("MasterThrottlingMetricsCollector"),
    FAULT_DETECTION_COLLECTOR_ERROR("FaultDetectionMetricsCollector");

    private String name;
    private String unit;
    private List<Statistics> statsList;

    private ExceptionsAndErrors(String name) {
        this.name = name;
        this.unit = "count";
        this.statsList = Collections.singletonList(Statistics.COUNT);
    }

    private ExceptionsAndErrors(String name, String unit, Statistics stats) {
        this.name = name;
        this.unit = unit;
        this.statsList = Collections.singletonList(stats);
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

