/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Comparator;
import javax.annotation.Nullable;

public class TemperatureVector {
    public static final String DIMENSION_KEY = "dimension";
    public static final String VALUE_KEY = "value";
    private NormalizedValue[] normalizedValues = new NormalizedValue[TemperatureDimension.values().length];

    public String toString() {
        return this.toJson().toString();
    }

    public JsonArray toJson() {
        JsonArray array = new JsonArray();
        for (TemperatureDimension dim : TemperatureDimension.values()) {
            NormalizedValue val = this.normalizedValues[dim.ordinal()];
            if (val == null) continue;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(DIMENSION_KEY, dim.NAME);
            jsonObject.addProperty(VALUE_KEY, val.toString());
            array.add((JsonElement)jsonObject);
        }
        return array;
    }

    @Nullable
    public NormalizedValue getTemperatureFor(TemperatureDimension dimension) {
        return this.normalizedValues[dimension.ordinal()];
    }

    public void updateTemperatureForDimension(TemperatureDimension dimension, NormalizedValue normalizedValue) {
        this.normalizedValues[dimension.ordinal()] = normalizedValue;
    }

    public static class NormalizedValue {
        public static final int MIN = 0;
        public static final int MAX = 10;
        private final short POINTS;

        public NormalizedValue(short heatValue) {
            if (heatValue < 0 || heatValue > 10) {
                String err = String.format("Only values between %d and %d allowed. Given: %d", 0, 10, heatValue);
                throw new IllegalArgumentException(err);
            }
            this.POINTS = heatValue;
        }

        public static NormalizedValue calculate(double consumedByCandidate, double totalConsumption) {
            return new NormalizedValue((short)(consumedByCandidate * 10.0 / totalConsumption));
        }

        public NormalizedValue diff(NormalizedValue b) {
            return new NormalizedValue((short)(this.POINTS - b.POINTS));
        }

        public boolean isGreaterThan(NormalizedValue b) {
            return this.POINTS > b.POINTS;
        }

        public Comparator<NormalizedValue> comparator() {
            return Comparator.comparingInt(o -> o.POINTS);
        }

        public short getPOINTS() {
            return this.POINTS;
        }

        public String toString() {
            return "" + this.POINTS;
        }
    }
}

