/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.ShardProfileSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShardStore {
    private static final Logger LOG = LogManager.getLogger(ShardStore.class);
    Map<String, Map<Integer, ShardProfileSummary>> list = new ConcurrentHashMap<String, Map<Integer, ShardProfileSummary>>();

    @Nonnull
    public synchronized ShardProfileSummary getOrCreateIfAbsent(String indexName, int shardId) {
        ShardProfileSummary shardProfileSummary;
        Map<Integer, ShardProfileSummary> innerMap = this.list.get(indexName);
        if (innerMap == null) {
            innerMap = new ConcurrentHashMap<Integer, ShardProfileSummary>();
            this.list.put(indexName, innerMap);
        }
        if ((shardProfileSummary = innerMap.get(shardId)) == null) {
            shardProfileSummary = new ShardProfileSummary(indexName, shardId);
            innerMap.put(shardId, shardProfileSummary);
        }
        return shardProfileSummary;
    }

    public List<ShardProfileSummary> getAllShards() {
        ArrayList<ShardProfileSummary> shardProfileSummaryList = new ArrayList<ShardProfileSummary>();
        for (Map<Integer, ShardProfileSummary> shardIdToShardMap : this.list.values()) {
            shardProfileSummaryList.addAll(shardIdToShardMap.values());
        }
        return shardProfileSummaryList;
    }
}

