/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;

public class RawMetricsVector {
    public static final String DIMENSION_KEY = "metrics_dimension";
    public static final String VALUE_KEY = "metrics_value";
    private double[] metricsValues = new double[TemperatureDimension.values().length];

    public String toString() {
        return this.toJson().toString();
    }

    public JsonArray toJson() {
        JsonArray array = new JsonArray();
        for (TemperatureDimension dim : TemperatureDimension.values()) {
            double val = this.metricsValues[dim.ordinal()];
            if (val == 0.0) continue;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(DIMENSION_KEY, dim.NAME);
            jsonObject.addProperty(VALUE_KEY, (Number)val);
            array.add((JsonElement)jsonObject);
        }
        return array;
    }

    @Nullable
    public double getMetricsFor(TemperatureDimension dimension) {
        return this.metricsValues[dimension.ordinal()];
    }

    public void updateRawMetricsForDimension(TemperatureDimension dimension, double metricsValue) {
        this.metricsValues[dimension.ordinal()] = metricsValue;
    }
}

