/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.exceptions.MalformedThresholdFile;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.exceptions.OverridesAndPrecedenceOrderCountMismatch;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.exceptions.OverridesAndPrecedenceOrderValueMismatch;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Threshold {
    private final String name;
    private String pathToFile;
    private final String defaultVal;
    private long creationTime;
    private List<String> overridePrecedenceOrder;
    private Map<String, Map<String, String>> overrides;
    private boolean creationTimeModifiedOnce;
    private boolean pathToFileModifiedOnce;

    public String getName() {
        return this.name;
    }

    Threshold(@JsonProperty(value="name") String name, @JsonProperty(value="default") String defaultVal, @JsonProperty(value="overrides") Map<String, Map<String, String>> overrides, @JsonProperty(value="precedence-order") List<String> overridePrecedenceOrder) {
        this.name = name;
        this.defaultVal = defaultVal;
        this.creationTime = 0L;
        this.overridePrecedenceOrder = overridePrecedenceOrder;
        this.overrides = overrides;
        this.pathToFile = null;
        this.pathToFileModifiedOnce = false;
        this.creationTimeModifiedOnce = false;
    }

    public String get(RcaConf rcaConf) {
        for (String overrideCategory : this.overridePrecedenceOrder) {
            Map<String, String> inCategoryMap = this.overrides.get(overrideCategory);
            String val = inCategoryMap.get(rcaConf.getTagMap().get(overrideCategory));
            if (val == null) continue;
            return val;
        }
        return this.defaultVal;
    }

    String getPathToFile() {
        return this.pathToFile;
    }

    void setPathToFile(String pathToFile) {
        if (this.pathToFileModifiedOnce) {
            throw new RuntimeException("Path to the threshold can be set only once.");
        }
        this.pathToFile = pathToFile;
        this.pathToFileModifiedOnce = true;
    }

    void setCreationTime(long creationTime) {
        if (this.creationTimeModifiedOnce) {
            throw new RuntimeException("Creation time of a threshold can be modified only once.");
        }
        this.creationTime = creationTime;
        this.creationTimeModifiedOnce = true;
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void validate() throws MalformedThresholdFile {
        if (this.name == null || this.defaultVal == null) {
            throw new MalformedThresholdFile(this.pathToFile, "'name' and 'default' keys are mandatory.");
        }
        String filename = new File(this.pathToFile).getName();
        if (!filename.split("\\.")[0].equals(this.name)) {
            throw new MalformedThresholdFile(this.pathToFile, "The name of the file (without the extension) and the value of the 'name' key in json, should match.");
        }
        if (this.overrides != null && this.overridePrecedenceOrder != null) {
            if (this.overrides.size() != this.overridePrecedenceOrder.size()) {
                String msg = "Elements in overrides and precedence-order are not the same.";
                throw new OverridesAndPrecedenceOrderCountMismatch(this.pathToFile, msg);
            }
            for (String cat : this.overridePrecedenceOrder) {
                if (this.overrides.get(cat) != null) continue;
                String msg = String.format("'%s' exists in the precedence-order but not in the overrides", cat);
                throw new OverridesAndPrecedenceOrderValueMismatch(this.pathToFile, msg);
            }
        } else {
            if (this.overrides != null || this.overridePrecedenceOrder != null) {
                String msg = "Between overrides and precedence-order, either you specify both or none.";
                throw new OverridesAndPrecedenceOrderValueMismatch(this.pathToFile, msg);
            }
            this.overrides = new HashMap<String, Map<String, String>>();
            this.overridePrecedenceOrder = new ArrayList<String>();
        }
    }
}

