/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.ConnectedComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Stats {
    private long totalNodesCount = 0L;
    private long leafNodesCount = 0L;
    private long leavesAddedToAnalysisFlowField = 0L;
    private Map<Integer, ConnectedComponent> graphs = new HashMap<Integer, ConnectedComponent>();
    private Set<String> mutedGraphNodes;
    private Set<String> mutedActions = new HashSet<String>();
    private static volatile Stats instance = null;

    public void incrementLeavesAddedToAnalysisFlowField() {
        ++this.leavesAddedToAnalysisFlowField;
    }

    private Stats() {
    }

    public static Stats getInstance() {
        if (instance == null) {
            instance = new Stats();
        }
        return instance;
    }

    public long getTotalNodesCount() {
        return this.totalNodesCount;
    }

    public long getLeafNodesCount() {
        return this.leafNodesCount;
    }

    public long getLeavesAddedToAnalysisFlowField() {
        return this.leavesAddedToAnalysisFlowField;
    }

    void incrementTotalNodesCount() {
        ++this.totalNodesCount;
    }

    void incrementLeafNodesCount() {
        ++this.leafNodesCount;
        this.incrementTotalNodesCount();
    }

    public int getGraphsCount() {
        return this.graphs.size();
    }

    public void addNewGraph(ConnectedComponent connectedComponent) {
        this.graphs.put(connectedComponent.getGraphId(), connectedComponent);
    }

    void removeGraph(int graphId) {
        this.graphs.remove(graphId);
    }

    public ConnectedComponent getGraphById(int graphId) {
        return this.graphs.get(graphId);
    }

    public List<ConnectedComponent> getConnectedComponents() {
        this.mutedGraphNodes = ConcurrentHashMap.newKeySet((int)this.getTotalNodesCount());
        return new ArrayList<ConnectedComponent>(this.graphs.values());
    }

    public void updateMutedGraphNodes(Set<String> nodeNames) {
        this.mutedGraphNodes.clear();
        this.mutedGraphNodes.addAll(nodeNames);
    }

    public void updateMutedActions(Set<String> actions) {
        this.mutedActions.clear();
        this.mutedActions.addAll(actions);
    }

    public boolean addToMutedGraphNodes(String nodeName) {
        return this.mutedGraphNodes.add(nodeName);
    }

    public boolean isNodeMuted(String nodeName) {
        return this.mutedGraphNodes.contains(nodeName);
    }

    public boolean isActionMuted(String actionName) {
        return this.mutedActions.contains(actionName);
    }

    public Set<String> getMutedGraphNodes() {
        return this.mutedGraphNodes;
    }

    public int getMutedGraphNodesCount() {
        int count = 0;
        if (this.mutedGraphNodes != null) {
            count = this.mutedGraphNodes.size();
        }
        return count;
    }

    public static void clear() {
        instance = null;
    }

    public void reset() {
        this.totalNodesCount = 0L;
        this.leafNodesCount = 0L;
        this.leavesAddedToAnalysisFlowField = 0L;
        this.graphs = null;
    }
}

