/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
class ConfJsonWrapper {
    public static final String RCA_STORE_LOC = "rca-store-location";
    public static final String THRESHOLD_STORE_LOC = "threshold-store-location";
    public static final String NEW_RCA_CHECK_MINS = "new-rca-check-minutes";
    public static final String NEW_THRESHOLDS_CHECK_MINS = "new-threshold-check-minutes";
    public static final String TAGS = "tags";
    public static final String REMOTE_PEERS = "remote-peers";
    public static final String DATASTORE = "datastore";
    public static final String ANALYSIS_GRAPH_IMPL = "analysis-graph-implementor";
    public static final String NETWORK_QUEUE_LEN = "network-queue-length";
    public static final String MAX_FLOW_UNIT_PER_VERTEX = "max-flow-units-per-vertex-buffer";
    public static final String RCA_CONFIG_SETTINGS = "rca-config-settings";
    public static final String MUTED_RCAS = "muted-rcas";
    public static final String MUTED_DECIDERS = "muted-deciders";
    public static final String MUTED_ACTIONS = "muted-actions";
    public static final String DECIDER_CONFIG_SETTINGS = "decider-config-settings";
    public static final String ACTION_CONFIG_SETTINGS = "action-config-settings";
    public static final String BUCKETIZATION_KEY = "bucketization";
    private final String rcaStoreLoc;
    private final String thresholdStoreLoc;
    private final long newRcaCheckPeriodicityMins;
    private final long newThresholdCheckPeriodicityMins;
    private final List<String> peerIpList;
    private final Map<String, String> tagMap;
    private final long creationTime = System.currentTimeMillis();
    private final Map<String, String> datastore;
    private final String analysisGraphEntryPoint;
    private final int networkQueueLength;
    private final int perVertexBufferLength;
    private final Map<String, Object> rcaConfigSettings;
    private final List<String> mutedRcaList;
    private final List<String> mutedDeciderList;
    private final List<String> mutedActionList;
    private final Map<String, Object> deciderConfigSettings;
    private final Map<String, Object> actionConfigSettings;
    private final Map<String, Object> bucketizationTunings;

    String getRcaStoreLoc() {
        return this.rcaStoreLoc;
    }

    String getThresholdStoreLoc() {
        return this.thresholdStoreLoc;
    }

    long getNewRcaCheckPeriodicityMins() {
        return this.newRcaCheckPeriodicityMins;
    }

    long getNewThresholdCheckPeriodicityMins() {
        return this.newThresholdCheckPeriodicityMins;
    }

    List<String> getPeerIpList() {
        return this.peerIpList;
    }

    Map<String, String> getTagMap() {
        return this.tagMap;
    }

    Map<String, String> getDatastore() {
        return Collections.unmodifiableMap(this.datastore);
    }

    String getAnalysisGraphEntryPoint() {
        return this.analysisGraphEntryPoint;
    }

    int getNetworkQueueLength() {
        return this.networkQueueLength;
    }

    int getPerVertexBufferLength() {
        return this.perVertexBufferLength;
    }

    List<String> getMutedRcaList() {
        return this.mutedRcaList;
    }

    public List<String> getMutedDeciderList() {
        return this.mutedDeciderList;
    }

    public List<String> getMutedActionList() {
        return this.mutedActionList;
    }

    public void setDatastoreRcaLogDirectory(String rcaLogLocation) {
        this.datastore.put("location-dir", rcaLogLocation);
    }

    Map<String, Object> getRcaConfigSettings() {
        return this.rcaConfigSettings;
    }

    Map<String, Object> getDeciderConfigSettings() {
        return this.deciderConfigSettings;
    }

    public Map<String, Object> getActionConfigSettings() {
        return this.actionConfigSettings;
    }

    public @Nullable Map<String, Object> getBucketizationTunings() {
        return this.bucketizationTunings;
    }

    ConfJsonWrapper(@JsonProperty(value="rca-store-location") String rcaStoreLoc, @JsonProperty(value="threshold-store-location") String thresholdStoreLoc, @JsonProperty(value="new-rca-check-minutes") long newRcaCheckPeriodicityMins, @JsonProperty(value="new-threshold-check-minutes") long newThresholdCheckPeriodicityMins, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="remote-peers") List<String> peers, @JsonProperty(value="datastore") Map<String, String> datastore, @JsonProperty(value="analysis-graph-implementor") String analysisGraphEntryPoint, @JsonProperty(value="network-queue-length") int networkQueueLength, @JsonProperty(value="max-flow-units-per-vertex-buffer") int perVertexBufferLength, @JsonProperty(value="rca-config-settings") Map<String, Object> rcaConfigSettings, @JsonProperty(value="muted-rcas") List<String> mutedRcas, @JsonProperty(value="muted-deciders") List<String> mutedDeciders, @JsonProperty(value="muted-actions") List<String> mutedActions, @JsonProperty(value="decider-config-settings") Map<String, Object> deciderConfigSettings, @JsonProperty(value="action-config-settings") Map<String, Object> actionConfigSettings, @JsonProperty(value="bucketization") Map<String, Object> bucketizationTunings) {
        this.rcaStoreLoc = rcaStoreLoc;
        this.thresholdStoreLoc = thresholdStoreLoc;
        this.newRcaCheckPeriodicityMins = newRcaCheckPeriodicityMins;
        this.newThresholdCheckPeriodicityMins = newThresholdCheckPeriodicityMins;
        this.peerIpList = peers;
        this.tagMap = tags;
        this.datastore = datastore;
        this.analysisGraphEntryPoint = analysisGraphEntryPoint;
        this.networkQueueLength = networkQueueLength;
        this.perVertexBufferLength = perVertexBufferLength;
        this.rcaConfigSettings = rcaConfigSettings;
        this.mutedRcaList = mutedRcas == null ? ImmutableList.of() : ImmutableList.copyOf(mutedRcas);
        this.mutedDeciderList = mutedDeciders == null ? ImmutableList.of() : ImmutableList.copyOf(mutedDeciders);
        this.mutedActionList = mutedActions == null ? ImmutableList.of() : ImmutableList.copyOf(mutedActions);
        this.deciderConfigSettings = deciderConfigSettings;
        this.actionConfigSettings = actionConfigSettings;
        this.bucketizationTunings = bucketizationTunings;
    }
}

