/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.GenericSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.DSL;

public class ShardProfileSummary
extends GenericSummary {
    public static final String SUMMARY_TABLE_NAME = "ShardProfileSummary";
    public static final String INDEX_NAME_KEY = "index_name";
    public static final String SHARD_ID_KEY = "shard_id";
    public static final String TEMPERATURE_KEY = "temperature";
    private final String indexName;
    private final int shardId;
    private final TemperatureVector temperatureVector;

    public ShardProfileSummary(String indexName, int shardId) {
        this.indexName = indexName;
        this.shardId = shardId;
        this.temperatureVector = new TemperatureVector();
    }

    public String identity() {
        return this.indexName + "::" + this.shardId;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public <T extends GeneratedMessageV3> T buildSummaryMessage() {
        throw new IllegalArgumentException();
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        throw new IllegalArgumentException();
    }

    @Override
    public String getTableName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(DSL.field((Name)DSL.name((String)INDEX_NAME_KEY), String.class));
        schema.add(DSL.field((Name)DSL.name((String)SHARD_ID_KEY), Integer.class));
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            schema.add(DSL.field((Name)DSL.name((String)dimension.NAME), Short.class));
        }
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.indexName);
        values.add(this.shardId);
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            values.add(this.temperatureVector.getTemperatureFor(dimension));
        }
        return values;
    }

    public JsonObject toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty(INDEX_NAME_KEY, this.indexName);
        summaryObj.addProperty(SHARD_ID_KEY, (Number)this.shardId);
        summaryObj.add(TEMPERATURE_KEY, (JsonElement)this.temperatureVector.toJson());
        return summaryObj;
    }

    @Nullable
    public TemperatureVector.NormalizedValue getHeatInDimension(TemperatureDimension dimension) {
        return this.temperatureVector.getTemperatureFor(dimension);
    }

    public void addTemperatureForDimension(TemperatureDimension dimension, TemperatureVector.NormalizedValue value) {
        this.temperatureVector.updateTemperatureForDimension(dimension, value);
    }
}

