/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.NodeLevelDimensionalSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.GenericSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.DSL;

public class FullNodeTemperatureSummary
extends GenericSummary {
    private static final Logger LOG = LogManager.getLogger(FullNodeTemperatureSummary.class);
    public static final String TABLE_NAME = FullNodeTemperatureSummary.class.getSimpleName();
    private final TemperatureVector temperatureVector;
    private final NodeLevelDimensionalSummary[] nodeDimensionProfiles;
    private final String nodeId;
    private final String hostAddress;

    public FullNodeTemperatureSummary(String nodeId, String hostAddress) {
        this.nodeId = nodeId;
        this.hostAddress = hostAddress;
        this.nodeDimensionProfiles = new NodeLevelDimensionalSummary[TemperatureDimension.values().length];
        this.temperatureVector = new TemperatureVector();
    }

    public TemperatureVector getTemperatureVector() {
        return this.temperatureVector;
    }

    public List<NodeLevelDimensionalSummary> getNodeDimensionProfiles() {
        return Arrays.asList(this.nodeDimensionProfiles);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void updateNodeDimensionProfile(NodeLevelDimensionalSummary nodeDimensionProfile) {
        TemperatureDimension dimension = nodeDimensionProfile.getProfileForDimension();
        this.nodeDimensionProfiles[dimension.ordinal()] = nodeDimensionProfile;
        this.temperatureVector.updateTemperatureForDimension(dimension, nodeDimensionProfile.getMeanTemperature());
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        ArrayList<GenericSummary> dimensionalSummaries = new ArrayList<GenericSummary>();
        for (NodeLevelDimensionalSummary dimSummary : this.nodeDimensionProfiles) {
            if (dimSummary == null) continue;
            dimensionalSummaries.add(dimSummary);
        }
        return dimensionalSummaries;
    }

    @Override
    public <T extends GeneratedMessageV3> T buildSummaryMessage() {
        throw new IllegalStateException("FullNodeTemperatureSummary should not be transported over the wire.");
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        throw new IllegalStateException("FullNodeTemperatureSummary should not be received over the wire.");
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(DSL.field((Name)DSL.name((String)"node_id"), String.class));
        schema.add(DSL.field((Name)DSL.name((String)"host_address"), String.class));
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            schema.add(DSL.field((Name)DSL.name((String)dimension.NAME), Short.class));
        }
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.getNodeId());
        values.add(this.getHostAddress());
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            values.add(this.temperatureVector.getTemperatureFor(dimension));
        }
        return values;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            TemperatureVector.NormalizedValue value = this.temperatureVector.getTemperatureFor(dimension);
            summaryObj.addProperty(dimension.NAME, value != null ? Short.valueOf(value.getPOINTS()) : null);
        }
        this.getNestedSummaryList().forEach(summary -> summaryObj.add(summary.getTableName(), summary.toJson()));
        return summaryObj;
    }
}

