/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;

public class CompactClusterLevelNodeSummary
extends CompactNodeSummary {
    private static final Logger LOG = LogManager.getLogger(CompactClusterLevelNodeSummary.class);
    public final String TABLE_NAME = CompactClusterLevelNodeSummary.class.getSimpleName();

    public CompactClusterLevelNodeSummary(String nodeId, String hostAddress) {
        super(nodeId, hostAddress);
    }

    public static CompactClusterLevelNodeSummary build(Record record) {
        String nodeId = (String)record.get("node_id", String.class);
        String hostIp = (String)record.get("host_address", String.class);
        CompactClusterLevelNodeSummary summary = new CompactClusterLevelNodeSummary(nodeId, hostIp);
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            try {
                Short mean = (Short)record.get(dimension.NAME + "_mean", Short.class);
                double total = (Double)record.get(dimension.NAME + "_total", Double.class);
                int num_shards = (Integer)record.get(dimension.NAME + "_num_shards", Integer.class);
                summary.setNumOfShards(dimension, num_shards);
                summary.setTemperatureForDimension(dimension, new TemperatureVector.NormalizedValue(mean));
                summary.setTotalConsumedByDimension(dimension, total);
            }
            catch (DataTypeException dex) {
                LOG.error("Could not create valid summary object.", (Throwable)dex);
            }
        }
        return summary;
    }
}

