/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.bucket;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.ResourceEnum;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.bucket.BucketCalculator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.bucket.UsageBucket;
import java.util.Map;

public class BasicBucketCalculator
implements BucketCalculator {
    double underUtilized;
    double healthyWithBuffer;
    double healthy;

    public BasicBucketCalculator(double underUtilized, double healthyWithBuffer, double healthy) {
        this.underUtilized = underUtilized;
        this.healthyWithBuffer = healthyWithBuffer;
        this.healthy = healthy;
        if (underUtilized >= healthyWithBuffer || healthyWithBuffer >= healthy) {
            throw new IllegalArgumentException("BasicBucketCalculator must be instantiated with underUtilized < healthyWithBuffer < healthy but saw " + this);
        }
    }

    public BasicBucketCalculator(Map<UsageBucket, Double> bucketThresholdMap) {
        this(bucketThresholdMap.get((Object)UsageBucket.UNDER_UTILIZED), bucketThresholdMap.get((Object)UsageBucket.HEALTHY_WITH_BUFFER), bucketThresholdMap.get((Object)UsageBucket.HEALTHY));
    }

    @Override
    public UsageBucket compute(ResourceEnum resource, double value) {
        return this.compute(value);
    }

    @Override
    public UsageBucket compute(double value) {
        if (value <= this.underUtilized) {
            return UsageBucket.UNDER_UTILIZED;
        }
        if (value <= this.healthyWithBuffer) {
            return UsageBucket.HEALTHY_WITH_BUFFER;
        }
        if (value <= this.healthy) {
            return UsageBucket.HEALTHY;
        }
        return UsageBucket.UNHEALTHY;
    }

    public String toString() {
        return "BasicBucketCalculator{underUtilized=" + this.underUtilized + ", healthyWithBuffer=" + this.healthyWithBuffer + ", healthy=" + this.healthy + '}';
    }
}

