/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.TopConsumerSummaryMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.persist.JooqFieldValue;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.GenericSummary;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DSL;

public class TopConsumerSummary
extends GenericSummary {
    public static final String TOP_CONSUMER_SUMMARY_TABLE = TopConsumerSummary.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HotClusterSummary.class);
    private final String name;
    private final double value;

    public TopConsumerSummary(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public TopConsumerSummaryMessage buildSummaryMessage() {
        TopConsumerSummaryMessage.Builder summaryMessageBuilder = TopConsumerSummaryMessage.newBuilder();
        summaryMessageBuilder.setName(this.name);
        summaryMessageBuilder.setValue(this.value);
        return summaryMessageBuilder.build();
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
    }

    public static TopConsumerSummary buildTopConsumerSummaryFromMessage(TopConsumerSummaryMessage message) {
        return new TopConsumerSummary(message.getName(), message.getValue());
    }

    public String toString() {
        return this.name + " " + this.value;
    }

    @Override
    public String getTableName() {
        return TOP_CONSUMER_SUMMARY_TABLE;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(TopConsumerSummaryField.CONSUMER_NAME_FIELD.getField());
        schema.add(TopConsumerSummaryField.CONSUMER_VALUE_FIELD.getField());
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(this.name);
        value.add(this.value);
        return value;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty("name", this.name);
        summaryObj.addProperty("value", (Number)this.value);
        return summaryObj;
    }

    @Nullable
    public static TopConsumerSummary buildSummary(Record record) {
        TopConsumerSummary summary = null;
        try {
            String name = (String)record.get(TopConsumerSummaryField.CONSUMER_NAME_FIELD.getField(), String.class);
            Double value = (Double)record.get(TopConsumerSummaryField.CONSUMER_VALUE_FIELD.getField(), Double.class);
            if (name != null && value != null) {
                summary = new TopConsumerSummary(name, value);
            }
        }
        catch (IllegalArgumentException ie) {
            LOG.error("Some fields might not be found in record, cause : {}", (Object)ie.getMessage());
        }
        catch (DataTypeException de) {
            LOG.error("Fails to convert data type");
        }
        catch (NullPointerException ne) {
            LOG.error("read null object from SQL, trace : {} ", (Object[])ne.getStackTrace());
        }
        return summary;
    }

    public static enum TopConsumerSummaryField implements JooqFieldValue
    {
        CONSUMER_NAME_FIELD("name", String.class),
        CONSUMER_VALUE_FIELD("value", Double.class);

        private String name;
        private Class<?> clazz;

        private TopConsumerSummaryField(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Field<?> getField() {
            return DSL.field((Name)DSL.name((String)this.name), this.clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class SQL_SCHEMA_CONSTANTS {
        public static final String CONSUMER_NAME_COL_NAME = "name";
        public static final String CONSUMER_VALUE_COL_NAME = "value";
    }
}

