/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.HotShardSummaryMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.persist.JooqFieldValue;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.GenericSummary;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DSL;

public class HotShardSummary
extends GenericSummary {
    public static final String HOT_SHARD_SUMMARY_TABLE = HotShardSummary.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HotShardSummary.class);
    private final String indexName;
    private final String shardId;
    private final String nodeId;
    private double cpu_utilization;
    private double cpu_utilization_threshold;
    private double io_throughput;
    private double io_throughput_threshold;
    private double io_sys_callrate;
    private double io_sys_callrate_threshold;
    private int timePeriodInSeconds;

    public HotShardSummary(String indexName, String shardId, String nodeId, int timePeriod) {
        this.indexName = indexName;
        this.shardId = shardId;
        this.nodeId = nodeId;
        this.timePeriodInSeconds = timePeriod;
    }

    public void setcpuUtilization(double cpu_utilization) {
        this.cpu_utilization = cpu_utilization;
    }

    public void setCpuUtilizationThreshold(double cpu_utilization_threshold) {
        this.cpu_utilization_threshold = cpu_utilization_threshold;
    }

    public void setIoThroughput(double io_throughput) {
        this.io_throughput = io_throughput;
    }

    public void setIoThroughputThreshold(double io_throughput_threshold) {
        this.io_throughput_threshold = io_throughput_threshold;
    }

    public void setIoSysCallrate(double io_sys_callrate) {
        this.io_sys_callrate = io_sys_callrate;
    }

    public void setIoSysCallrateThreshold(double io_sys_callrate_threshold) {
        this.io_sys_callrate_threshold = io_sys_callrate_threshold;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public double getCpuUtilization() {
        return this.cpu_utilization;
    }

    public double getIOThroughput() {
        return this.io_throughput;
    }

    public double getIOSysCallrate() {
        return this.io_sys_callrate;
    }

    public HotShardSummaryMessage buildSummaryMessage() {
        HotShardSummaryMessage.Builder summaryMessageBuilder = HotShardSummaryMessage.newBuilder();
        summaryMessageBuilder.setIndexName(this.indexName);
        summaryMessageBuilder.setShardId(this.shardId);
        summaryMessageBuilder.setNodeId(this.nodeId);
        summaryMessageBuilder.setCpuUtilization(this.cpu_utilization);
        summaryMessageBuilder.setCpuUtilizationThreshold(this.cpu_utilization_threshold);
        summaryMessageBuilder.setIoThroughput(this.io_throughput);
        summaryMessageBuilder.setIoThroughputThreshold(this.io_throughput_threshold);
        summaryMessageBuilder.setIoSysCallrate(this.io_sys_callrate);
        summaryMessageBuilder.setIoSysCallrateThreshold(this.io_sys_callrate_threshold);
        summaryMessageBuilder.setTimePeriod(this.timePeriodInSeconds);
        return summaryMessageBuilder.build();
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        messageBuilder.setHotShardSummary(this.buildSummaryMessage());
    }

    public static HotShardSummary buildHotShardSummaryFromMessage(HotShardSummaryMessage message) {
        HotShardSummary summary = new HotShardSummary(message.getIndexName(), message.getShardId(), message.getNodeId(), message.getTimePeriod());
        summary.setcpuUtilization(message.getCpuUtilization());
        summary.setCpuUtilizationThreshold(message.getCpuUtilizationThreshold());
        summary.setIoThroughput(message.getIoThroughput());
        summary.setIoThroughputThreshold(message.getIoThroughputThreshold());
        summary.setIoSysCallrate(message.getIoSysCallrate());
        summary.setIoSysCallrateThreshold(message.getIoSysCallrateThreshold());
        return summary;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.indexName, this.shardId, this.nodeId, String.valueOf(this.cpu_utilization), String.valueOf(this.cpu_utilization_threshold), String.valueOf(this.io_throughput), String.valueOf(this.io_throughput_threshold), String.valueOf(this.io_sys_callrate), String.valueOf(this.io_sys_callrate_threshold));
    }

    @Override
    public String getTableName() {
        return HOT_SHARD_SUMMARY_TABLE;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(HotShardSummaryField.INDEX_NAME_FIELD.getField());
        schema.add(HotShardSummaryField.SHARD_ID_FIELD.getField());
        schema.add(HotShardSummaryField.NODE_ID_FIELD.getField());
        schema.add(HotShardSummaryField.CPU_UTILIZATION_FIELD.getField());
        schema.add(HotShardSummaryField.CPU_UTILIZATION_THRESHOLD_FIELD.getField());
        schema.add(HotShardSummaryField.IO_THROUGHPUT_FIELD.getField());
        schema.add(HotShardSummaryField.IO_THROUGHPUT_THRESHOLD_FIELD.getField());
        schema.add(HotShardSummaryField.IO_SYSCALLRATE_FIELD.getField());
        schema.add(HotShardSummaryField.IO_SYSCALLRATE_THRESHOLD_FIELD.getField());
        schema.add(HotShardSummaryField.TIME_PERIOD_FIELD.getField());
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(this.indexName);
        value.add(this.shardId);
        value.add(this.nodeId);
        value.add(this.cpu_utilization);
        value.add(this.cpu_utilization_threshold);
        value.add(this.io_throughput);
        value.add(this.io_throughput_threshold);
        value.add(this.io_sys_callrate);
        value.add(this.io_sys_callrate_threshold);
        value.add(this.timePeriodInSeconds);
        return value;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty("index_name", this.indexName);
        summaryObj.addProperty("shard_id", this.shardId);
        summaryObj.addProperty("node_id", this.nodeId);
        summaryObj.addProperty("cpu_utilization", (Number)this.cpu_utilization);
        summaryObj.addProperty("cpu_utilization_threshold", (Number)this.cpu_utilization_threshold);
        summaryObj.addProperty("io_throughput", (Number)this.io_throughput);
        summaryObj.addProperty("io_throughput_threshold", (Number)this.io_throughput_threshold);
        summaryObj.addProperty("io_sys_callrate", (Number)this.io_sys_callrate);
        summaryObj.addProperty("io_sys_callrate_threshold", (Number)this.io_sys_callrate_threshold);
        summaryObj.addProperty("time_period", (Number)this.timePeriodInSeconds);
        return summaryObj;
    }

    @Nullable
    public static HotShardSummary buildSummary(Record record) {
        HotShardSummary summary = null;
        try {
            String indexName = (String)record.get(HotShardSummaryField.INDEX_NAME_FIELD.getField(), String.class);
            String shardId = (String)record.get(HotShardSummaryField.SHARD_ID_FIELD.getField(), String.class);
            String nodeId = (String)record.get(HotShardSummaryField.NODE_ID_FIELD.getField(), String.class);
            Double cpu_utilization = (Double)record.get(HotShardSummaryField.CPU_UTILIZATION_FIELD.getField(), Double.class);
            Double cpu_utilization_threshold = (Double)record.get(HotShardSummaryField.CPU_UTILIZATION_THRESHOLD_FIELD.getField(), Double.class);
            Double io_throughput = (Double)record.get(HotShardSummaryField.IO_THROUGHPUT_FIELD.getField(), Double.class);
            Double io_throughput_threshold = (Double)record.get(HotShardSummaryField.IO_THROUGHPUT_THRESHOLD_FIELD.getField(), Double.class);
            Double io_sys_callrate = (Double)record.get(HotShardSummaryField.IO_SYSCALLRATE_FIELD.getField(), Double.class);
            Double io_sys_callrate_threshold = (Double)record.get(HotShardSummaryField.IO_SYSCALLRATE_THRESHOLD_FIELD.getField(), Double.class);
            Integer timePeriod = (Integer)record.get(HotShardSummaryField.TIME_PERIOD_FIELD.getField(), Integer.class);
            summary = new HotShardSummary(indexName, shardId, nodeId, timePeriod);
            summary.setcpuUtilization(cpu_utilization);
            summary.setCpuUtilizationThreshold(cpu_utilization_threshold);
            summary.setIoThroughput(io_throughput);
            summary.setIoThroughputThreshold(io_throughput_threshold);
            summary.setIoSysCallrate(io_sys_callrate);
            summary.setIoSysCallrateThreshold(io_sys_callrate_threshold);
        }
        catch (IllegalArgumentException ie) {
            LOG.error("Some fields might not be found in record, cause : {}", (Object)ie.getMessage());
        }
        catch (DataTypeException de) {
            LOG.error("Fails to convert data type");
        }
        catch (NullPointerException ne) {
            LOG.error("read null object from SQL, trace : {} ", (Object[])ne.getStackTrace());
        }
        return summary;
    }

    public static enum HotShardSummaryField implements JooqFieldValue
    {
        INDEX_NAME_FIELD("index_name", String.class),
        SHARD_ID_FIELD("shard_id", String.class),
        NODE_ID_FIELD("node_id", String.class),
        CPU_UTILIZATION_FIELD("cpu_utilization", Double.class),
        CPU_UTILIZATION_THRESHOLD_FIELD("cpu_utilization_threshold", Double.class),
        IO_THROUGHPUT_FIELD("io_throughput", Double.class),
        IO_THROUGHPUT_THRESHOLD_FIELD("io_throughput_threshold", Double.class),
        IO_SYSCALLRATE_FIELD("io_sys_callrate", Double.class),
        IO_SYSCALLRATE_THRESHOLD_FIELD("io_sys_callrate_threshold", Double.class),
        TIME_PERIOD_FIELD("time_period", Integer.class);

        private String name;
        private Class<?> clazz;

        private HotShardSummaryField(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Field<?> getField() {
            return DSL.field((Name)DSL.name((String)this.name), this.clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class SQL_SCHEMA_CONSTANTS {
        public static final String INDEX_NAME_COL_NAME = "index_name";
        public static final String SHARD_ID_COL_NAME = "shard_id";
        public static final String NODE_ID_COL_NAME = "node_id";
        public static final String CPU_UTILIZATION_COL_NAME = "cpu_utilization";
        public static final String CPU_UTILIZATION_THRESHOLD_COL_NAME = "cpu_utilization_threshold";
        public static final String IO_THROUGHPUT_COL_NAME = "io_throughput";
        public static final String IO_THROUGHPUT_THRESHOLD_COL_NAME = "io_throughput_threshold";
        public static final String IO_SYSCALLRATE_COL_NAME = "io_sys_callrate";
        public static final String IO_SYSCALLRATE_THRESHOLD_COL_NAME = "io_sys_callrate_threshold";
        public static final String TIME_PERIOD_COL_NAME = "time_period";
    }
}

