/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.temperature;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;

public class CompactNodeTemperatureFlowUnit
extends ResourceFlowUnit<CompactNodeSummary> {
    private final CompactNodeSummary compactNodeTemperatureSummary;

    public CompactNodeTemperatureFlowUnit(long timeStamp, ResourceContext context, CompactNodeSummary resourceSummary, boolean persistSummary) {
        super(timeStamp, context, resourceSummary, persistSummary);
        this.compactNodeTemperatureSummary = resourceSummary;
    }

    public CompactNodeTemperatureFlowUnit(long timeStamp) {
        super(timeStamp);
        this.compactNodeTemperatureSummary = null;
    }

    @Override
    public FlowUnitMessage buildFlowUnitMessage(String graphNode, InstanceDetails.Id esNode) {
        FlowUnitMessage.Builder builder = FlowUnitMessage.newBuilder();
        builder.setGraphNode(graphNode);
        builder.setEsNode(esNode.toString());
        builder.setTimeStamp(System.currentTimeMillis());
        if (this.compactNodeTemperatureSummary != null) {
            this.compactNodeTemperatureSummary.buildSummaryMessageAndAddToFlowUnit(builder);
        }
        return builder.build();
    }

    public static CompactNodeTemperatureFlowUnit buildFlowUnitFromWrapper(FlowUnitMessage message) {
        CompactNodeSummary compactNodeTemperatureSummary = CompactNodeSummary.buildNodeTemperatureProfileFromMessage(message.getNodeTemperatureSummary());
        return new CompactNodeTemperatureFlowUnit(message.getTimeStamp(), new ResourceContext(Resources.State.UNKNOWN), compactNodeTemperatureSummary, false);
    }

    public CompactNodeSummary getCompactNodeTemperatureSummary() {
        return this.compactNodeTemperatureSummary;
    }
}

