/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.HotNodeSummaryMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.Resource;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.Resources;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NodeConfigFlowUnit
extends ResourceFlowUnit<HotNodeSummary> {
    private final HashMap<Resource, HotResourceSummary> configMap;

    public NodeConfigFlowUnit(long timeStamp) {
        super(timeStamp);
        this.configMap = new HashMap();
    }

    public NodeConfigFlowUnit(long timeStamp, NodeKey nodeKey) {
        super(timeStamp, new ResourceContext(Resources.State.HEALTHY), null, false);
        this.setSummary(new HotNodeSummary(nodeKey.getNodeId(), nodeKey.getHostAddress()));
        this.configMap = new HashMap();
    }

    public void addConfig(Resource resource, double value) {
        HotResourceSummary configSummary = new HotResourceSummary(resource, Double.NaN, value, 0);
        this.configMap.put(resource, configSummary);
    }

    public void addConfig(HotResourceSummary configSummary) {
        this.configMap.put(configSummary.getResource(), configSummary);
    }

    public boolean hasConfig(Resource resource) {
        return this.configMap.containsKey(resource);
    }

    public double readConfig(Resource resource) {
        HotResourceSummary configSummary = this.configMap.getOrDefault(resource, null);
        if (configSummary == null) {
            return Double.NaN;
        }
        return configSummary.getValue();
    }

    public List<Resource> getConfigList() {
        return new ArrayList<Resource>(this.configMap.keySet());
    }

    @Override
    public boolean isEmpty() {
        return this.configMap.isEmpty();
    }

    @Override
    public FlowUnitMessage buildFlowUnitMessage(String graphNode, InstanceDetails.Id esNode) {
        this.configMap.values().forEach(resourceSummary -> ((HotNodeSummary)this.getSummary()).appendNestedSummary((HotResourceSummary)resourceSummary));
        return super.buildFlowUnitMessage(graphNode, esNode);
    }

    public static NodeConfigFlowUnit buildFlowUnitFromWrapper(FlowUnitMessage message) {
        NodeConfigFlowUnit nodeConfigFlowUnit;
        if (message.getSummaryOneofCase() == FlowUnitMessage.SummaryOneofCase.HOTNODESUMMARY) {
            HotNodeSummaryMessage nodeSummaryMessage = message.getHotNodeSummary();
            NodeKey nodeKey = new NodeKey(new InstanceDetails.Id(nodeSummaryMessage.getNodeID()), new InstanceDetails.Ip(nodeSummaryMessage.getHostAddress()));
            nodeConfigFlowUnit = new NodeConfigFlowUnit(message.getTimeStamp(), nodeKey);
            if (nodeSummaryMessage.hasHotResourceSummaryList()) {
                for (int i = 0; i < nodeSummaryMessage.getHotResourceSummaryList().getHotResourceSummaryCount(); ++i) {
                    nodeConfigFlowUnit.addConfig(HotResourceSummary.buildHotResourceSummaryFromMessage(nodeSummaryMessage.getHotResourceSummaryList().getHotResourceSummary(i)));
                }
            }
        } else {
            nodeConfigFlowUnit = new NodeConfigFlowUnit(message.getTimeStamp());
        }
        return nodeConfigFlowUnit;
    }
}

