/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.persistence.FileRotate;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersistableSlidingWindow
extends SlidingWindow<SlidingWindowData> {
    private static final Logger LOG = LogManager.getLogger(PersistableSlidingWindow.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final long WRITE_PERIOD_MS = 300000L;
    private Path pathToFile;
    private boolean enablePersistence;
    private long lastWriteTimeEpochMs;

    public PersistableSlidingWindow(int slidingWindowSize, TimeUnit timeUnit, Path filePath) {
        super(slidingWindowSize, timeUnit);
        this.pathToFile = filePath;
        boolean bl = this.enablePersistence = this.pathToFile != null;
        if (!this.enablePersistence) {
            LOG.debug("Persistence is not enabled for {}:{}", (Object)this.getClass().getSimpleName(), (Object)this);
            return;
        }
        this.lastWriteTimeEpochMs = Instant.now().toEpochMilli();
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                this.load(this.pathToFile);
            }
            catch (IOException ex) {
                LOG.error("Unable to load previous data from {} into {}", (Object)this.pathToFile, (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        } else {
            LOG.warn("{}:{} attempted to load data from {}, but the file doesn't exist", (Object)this.getClass().getSimpleName(), (Object)this, (Object)filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void load(Path path) throws IOException {
        LineIterator it = FileUtils.lineIterator((File)path.toFile(), (String)"UTF-8");
        try {
            while (it.hasNext()) {
                String line = it.nextLine();
                SlidingWindowData data = (SlidingWindowData)objectMapper.readValue(line, SlidingWindowData.class);
                this.next(data);
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
    }

    protected synchronized void write() throws IOException {
        if (!this.enablePersistence || 300000L < Instant.now().toEpochMilli() - this.lastWriteTimeEpochMs) {
            return;
        }
        String tmpFile = this.pathToFile.toString();
        Path tmpPath = Paths.get(tmpFile, new String[0]);
        if (!Files.exists(tmpPath, new LinkOption[0])) {
            Files.createFile(tmpPath, new FileAttribute[0]);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile, false));){
            Iterator it = this.windowDeque.descendingIterator();
            while (it.hasNext()) {
                writer.write(objectMapper.writeValueAsString(it.next()));
                writer.write(System.lineSeparator());
            }
            writer.flush();
            FileRotate.rotateFile(tmpPath, this.pathToFile);
            this.lastWriteTimeEpochMs = Instant.now().toEpochMilli();
        }
    }
}

