/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.SymptomFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Symptom
extends NonLeafNode<SymptomFlowUnit> {
    private static final Logger LOG = LogManager.getLogger(Symptom.class);

    public Symptom(long evaluationIntervalSeconds) {
        super(0, evaluationIntervalSeconds);
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        SymptomFlowUnit result;
        LOG.debug("rca: Executing handleRca: {}", (Object)this.getClass().getSimpleName());
        long startTime = System.currentTimeMillis();
        try {
            result = (SymptomFlowUnit)this.operate();
        }
        catch (Exception ex) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_OPERATE, this.name(), 1);
            ex.printStackTrace();
            result = SymptomFlowUnit.generic();
        }
        long endTime = System.currentTimeMillis();
        long durationMillis = endTime - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), durationMillis);
        this.setFlowUnits(Collections.singletonList(result));
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
    }

    @Override
    public void handleNodeMuted() {
        this.setLocalFlowUnit(SymptomFlowUnit.generic());
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }
}

