/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.GenericSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Rca<T extends ResourceFlowUnit>
extends NonLeafNode<T> {
    private static final Logger LOG = LogManager.getLogger(Rca.class);

    public Rca(long evaluationIntervalSeconds) {
        super(0, evaluationIntervalSeconds);
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        ResourceFlowUnit<GenericSummary> result;
        LOG.debug("rca: Executing fromLocal: {}", (Object)this.getClass().getSimpleName());
        long startTime = System.currentTimeMillis();
        try {
            result = (ResourceFlowUnit<GenericSummary>)this.operate();
        }
        catch (Exception ex) {
            LOG.error("Exception in operate.", (Throwable)ex);
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_OPERATE, this.name(), 1);
            result = ResourceFlowUnit.generic();
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), duration);
        this.setLocalFlowUnit(result);
    }

    @Override
    public void handleNodeMuted() {
        this.setLocalFlowUnit(ResourceFlowUnit.generic());
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
        long startTime = System.currentTimeMillis();
        for (ResourceFlowUnit flowUnit : this.getFlowUnits()) {
            try {
                args.getPersistable().write(this, flowUnit);
            }
            catch (Exception ex) {
                LOG.error("Caught exception while persisting node: {}", (Object)args.getNode().name(), (Object)ex);
                PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_PERSIST, this.name(), 1);
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.RCA_PERSIST_CALL, this.name(), duration);
    }
}

