/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.PerformanceAnalyzerApp;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.FlowUnitMessage;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.NodeConfigFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.NonLeafNode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EsConfigNode
extends NonLeafNode<NodeConfigFlowUnit> {
    private static final Logger LOG = LogManager.getLogger(EsConfigNode.class);

    public EsConfigNode() {
        super(0, 5L);
    }

    @Override
    public void generateFlowUnitListFromLocal(FlowUnitOperationArgWrapper args) {
        NodeConfigFlowUnit result;
        long startTime = System.currentTimeMillis();
        try {
            result = (NodeConfigFlowUnit)this.operate();
        }
        catch (Exception ex) {
            LOG.error("Exception in operate.", (Throwable)ex);
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.EXCEPTION_IN_OPERATE, this.name(), 1);
            result = new NodeConfigFlowUnit(System.currentTimeMillis());
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        PerformanceAnalyzerApp.RCA_GRAPH_METRICS_AGGREGATOR.updateStat(RcaGraphMetrics.GRAPH_NODE_OPERATE_CALL, this.name(), duration);
        this.setLocalFlowUnit(result);
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList<NodeConfigFlowUnit> flowUnitList = new ArrayList<NodeConfigFlowUnit>();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(NodeConfigFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }

    @Override
    public void handleNodeMuted() {
        this.setLocalFlowUnit(new NodeConfigFlowUnit(System.currentTimeMillis()));
    }

    @Override
    public void persistFlowUnit(FlowUnitOperationArgWrapper args) {
    }
}

