/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.formatter;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.eval.Statistics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.format.Formatter;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class StatsCollectorFormatter
implements Formatter {
    StringBuilder formatted = new StringBuilder();
    String sep = "";
    long startTime;
    long endTime;

    private void format(MeasurementSet measurementSet, Statistics aggregationType, String name, Number value) {
        this.formatted.append(this.sep);
        this.formatted.append(measurementSet.getName()).append("=").append(value);
        if (!measurementSet.getUnit().isEmpty()) {
            this.formatted.append(" ").append(measurementSet.getUnit());
        }
        this.formatted.append(" ").append("aggr|").append((Object)aggregationType);
        if (!name.isEmpty()) {
            this.formatted.append(" ").append("key|").append(name);
        }
        this.sep = ",";
    }

    @Override
    public void formatNamedAggregatedValue(MeasurementSet measurementSet, Statistics aggregationType, String name, Number value) {
        this.format(measurementSet, aggregationType, name, value);
    }

    @Override
    public void formatAggregatedValue(MeasurementSet measurementSet, Statistics aggregationType, Number value) {
        this.format(measurementSet, aggregationType, "", value);
    }

    @Override
    public void setStartAndEndTime(long start, long end) {
        this.startTime = start;
        this.endTime = end;
    }

    public List<StatsCollectorReturn> getAllMetrics() {
        ArrayList<StatsCollectorReturn> list = new ArrayList<StatsCollectorReturn>();
        StatsCollectorReturn statsCollectorReturn = new StatsCollectorReturn(this.startTime, this.endTime);
        statsCollectorReturn.statsdata.put("Metrics", this.formatted.toString());
        list.add(statsCollectorReturn);
        return list;
    }

    public static class StatsCollectorReturn {
        private Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
        private Map<String, String> statsdata = new HashMap<String, String>();
        private Map<String, Double> latencies = new HashMap<String, Double>();
        private long startTimeMillis;
        private long endTimeMillis;

        public StatsCollectorReturn(long startTimeMillis, long endTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.endTimeMillis = endTimeMillis;
        }

        public Map<String, AtomicInteger> getCounters() {
            return this.counters;
        }

        public Map<String, String> getStatsdata() {
            return this.statsdata;
        }

        public Map<String, Double> getLatencies() {
            return this.latencies;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public long getEndTimeMillis() {
            return this.endTimeMillis;
        }

        public boolean isEmpty() {
            return this.counters.isEmpty() && this.statsdata.isEmpty() && this.latencies.isEmpty();
        }
    }
}

