/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.configs;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;

public class HotShardClusterRcaConfig {
    public static final String CONFIG_NAME = "hot-shard-cluster-rca";
    private Double cpuUtilizationClusterThreshold;
    private Double ioTotThroughputClusterThreshold;
    private Double ioTotSysCallRateClusterThreshold;
    public static final double DEFAULT_CPU_UTILIZATION_CLUSTER_THRESHOLD = 0.3;
    public static final double DEFAULT_IO_TOTAL_THROUGHPUT_CLUSTER_THRESHOLD = 0.3;
    public static final double DEFAULT_IO_TOTAL_SYSCALL_RATE_CLUSTER_THRESHOLD = 0.3;

    public HotShardClusterRcaConfig(RcaConf rcaConf) {
        this.cpuUtilizationClusterThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "cpu-utilization-cluster-percentage", 0.3, s -> s > 0.0, Double.class);
        this.ioTotThroughputClusterThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "io-total-throughput-cluster-percentage", 0.3, s -> s > 0.0, Double.class);
        this.ioTotSysCallRateClusterThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "io-total-syscallrate-cluster-percentage", 0.3, s -> s > 0.0, Double.class);
    }

    public double getCpuUtilizationClusterThreshold() {
        return this.cpuUtilizationClusterThreshold;
    }

    public double getIoTotThroughputClusterThreshold() {
        return this.ioTotThroughputClusterThreshold;
    }

    public double getIoTotSysCallRateClusterThreshold() {
        return this.ioTotSysCallRateClusterThreshold;
    }

    public static class RCA_CONF_KEY_CONSTANTS {
        private static final String CPU_UTILIZATION_CLUSTER_THRESHOLD = "cpu-utilization-cluster-percentage";
        private static final String CLUSTER_IO_THROUGHPUT_CLUSTER_THRESHOLD = "io-total-throughput-cluster-percentage";
        private static final String CLUSTER_IO_SYSCALLRATE_CLUSTER_THRESHOLD = "io-total-syscallrate-cluster-percentage";
    }
}

