/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.configs;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HotNodeClusterRcaConfig {
    private static final Logger LOG = LogManager.getLogger(HotNodeClusterRcaConfig.class);
    public static final String CONFIG_NAME = "hot-node-cluster-rca";
    private Double unbalancedResourceThreshold;
    private Double resourceUsageLowerBoundThreshold;
    public static final double DEFAULT_UNBALANCED_RESOURCE_THRES = 0.3;
    public static final double DEFAULT_RESOURCE_USAGE_LOWER_BOUND_THRES = 0.1;

    public HotNodeClusterRcaConfig(RcaConf rcaConf) {
        this.unbalancedResourceThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "unbalanced-resource-percentage", 0.3, s -> s > 0.0, Double.class);
        this.resourceUsageLowerBoundThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "resource-usage-lower-bound-percentage", 0.1, s -> s > 0.0, Double.class);
    }

    public double getUnbalancedResourceThreshold() {
        return this.unbalancedResourceThreshold;
    }

    public double getResourceUsageLowerBoundThreshold() {
        return this.resourceUsageLowerBoundThreshold;
    }

    public static class RCA_CONF_KEY_CONSTANTS {
        public static final String UNBALANCED_RESOURCE_THRES = "unbalanced-resource-percentage";
        public static final String RESOURCE_USAGE_LOWER_BOUND_THRES = "resource-usage-lower-bound-percentage";
    }
}

