/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.plugins;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.ActionListener;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.Publisher;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.plugins.Plugin;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.plugins.PluginControllerConfig;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginController {
    private static final Logger LOG = LogManager.getLogger(PluginController.class);
    private final Publisher publisher;
    private List<Plugin> plugins;
    private PluginControllerConfig pluginControllerConfig;

    public PluginController(PluginControllerConfig pluginConfig, Publisher publisher) {
        this.pluginControllerConfig = pluginConfig;
        this.publisher = publisher;
        this.plugins = new ArrayList<Plugin>();
    }

    public void initPlugins() {
        this.loadFrameworkPlugins();
        this.registerActionListeners();
    }

    private void loadFrameworkPlugins() {
        for (Class<? extends Plugin> pluginClass : this.pluginControllerConfig.getFrameworkPlugins()) {
            Constructor<?>[] constructors = pluginClass.getConstructors();
            if (constructors.length == 0) {
                throw new IllegalStateException("no public constructor found for plugin class: [" + pluginClass.getName() + "]");
            }
            if (constructors.length > 1) {
                throw new IllegalStateException("unique constructor expected for plugin class: [" + pluginClass.getName() + "]");
            }
            if (constructors[0].getParameterCount() != 0) {
                throw new IllegalStateException("default constructor expected for plugin class: [" + pluginClass.getName() + "]");
            }
            try {
                this.plugins.add((Plugin)constructors[0].newInstance(new Object[0]));
                LOG.info("loaded plugin: [{}]", (Object)this.plugins.get(this.plugins.size() - 1).name());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOG.error("Failed to instantiate plugin", (Throwable)e);
                throw new IllegalStateException("Failed to instantiate plugin: [" + pluginClass.getName() + "]", e);
            }
        }
    }

    private void registerActionListeners() {
        for (Plugin plugin : this.plugins) {
            if (!ActionListener.class.isAssignableFrom(plugin.getClass())) continue;
            this.publisher.addActionListener((ActionListener)((Object)plugin));
        }
    }

    @VisibleForTesting
    List<Plugin> getPlugins() {
        return this.plugins;
    }
}

