/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.linux;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.SchedMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.os.ThreadSched;
import java.util.HashMap;
import java.util.Map;

public class LinuxSchedMetricsGenerator
implements SchedMetricsGenerator {
    private final Map<String, ThreadSched.SchedMetrics> schedMetricsMap = new HashMap<String, ThreadSched.SchedMetrics>();

    @Override
    public double getAvgRuntime(String threadId) {
        return this.schedMetricsMap.get((Object)threadId).avgRuntime;
    }

    @Override
    public double getAvgWaittime(String threadId) {
        return this.schedMetricsMap.get((Object)threadId).avgWaittime;
    }

    @Override
    public double getContextSwitchRate(String threadId) {
        return this.schedMetricsMap.get((Object)threadId).contextSwitchRate;
    }

    @Override
    public boolean hasSchedMetrics(String threadId) {
        return this.schedMetricsMap.containsKey(threadId);
    }

    @Override
    public void addSample() {
        this.schedMetricsMap.clear();
        ThreadSched.INSTANCE.addSample();
    }

    public void setSchedMetric(String threadId, ThreadSched.SchedMetrics schedMetrics) {
        this.schedMetricsMap.put(threadId, schedMetrics);
    }
}

