/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.linux;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.hwnet.Disks;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.hwnet.MountedPartitions;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.hwnet.NetworkE2E;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.hwnet.NetworkInterface;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.CPUPagingActivityGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.DiskIOMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.DiskMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.IPMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.MountedPartitionMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.OSMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.SchedMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.TCPMetricsGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.os.OSGlobals;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.os.ThreadCPU;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.os.ThreadDiskIO;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.os.ThreadSched;
import java.util.Set;

public class LinuxOSMetricsGenerator
implements OSMetricsGenerator {
    private static OSMetricsGenerator osMetricsGenerator = new LinuxOSMetricsGenerator();

    public static OSMetricsGenerator getInstance() {
        return osMetricsGenerator;
    }

    @Override
    public String getPid() {
        return OSGlobals.getPid();
    }

    @Override
    public CPUPagingActivityGenerator getPagingActivityGenerator() {
        return ThreadCPU.INSTANCE.getCPUPagingActivity();
    }

    @Override
    public Set<String> getAllThreadIds() {
        return ThreadCPU.INSTANCE.getCPUPagingActivity().getAllThreadIds();
    }

    @Override
    public DiskIOMetricsGenerator getDiskIOMetricsGenerator() {
        return ThreadDiskIO.getIOUtilization();
    }

    @Override
    public SchedMetricsGenerator getSchedMetricsGenerator() {
        return ThreadSched.INSTANCE.getSchedLatency();
    }

    @Override
    public TCPMetricsGenerator getTCPMetricsGenerator() {
        return NetworkE2E.getTCPMetricsHandler();
    }

    @Override
    public IPMetricsGenerator getIPMetricsGenerator() {
        return NetworkInterface.getLinuxIPMetricsGenerator();
    }

    @Override
    public DiskMetricsGenerator getDiskMetricsGenerator() {
        return Disks.getDiskMetricsHandler();
    }

    @Override
    public MountedPartitionMetricsGenerator getMountedPartitionMetricsGenerator() {
        return MountedPartitions.getLinuxMountedPartitionMetricsGenerator();
    }
}

