/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.linux;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.MountedPartitionMetrics;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.hwnet.MountedPartitions;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.MountedPartitionMetricsGenerator;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LinuxMountedPartitionMetricsGenerator
implements MountedPartitionMetricsGenerator {
    private static final Map<String, MountedPartitionMetrics> suppliers = new HashMap<String, MountedPartitionMetrics>();

    @Override
    public void addSample() {
        MountedPartitions.addSample();
    }

    @Override
    public Set<String> getAllMountPoints() {
        return ImmutableSet.copyOf(suppliers.keySet());
    }

    public void addSupplier(String mountPoint, MountedPartitionMetrics supplier) {
        suppliers.put(mountPoint, supplier);
    }

    @Override
    public String getDevicePartition(String mountPoint) {
        return suppliers.get(mountPoint).getDevicePartition();
    }

    @Override
    public long getTotalSpace(String mountPoint) {
        return suppliers.get(mountPoint).getTotalSpace();
    }

    @Override
    public long getFreeSpace(String mountPoint) {
        return suppliers.get(mountPoint).getFreeSpace();
    }

    @Override
    public long getUsableFreeSpace(String mountPoint) {
        return suppliers.get(mountPoint).getUsableFreeSpace();
    }
}

