/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.linux;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics_generator.CPUPagingActivityGenerator;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.os.ThreadCPU;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LinuxCPUPagingActivityGenerator
implements CPUPagingActivityGenerator {
    private Map<String, Double> cpu = new HashMap<String, Double>();
    private Map<String, Double[]> pagingActivities = new HashMap<String, Double[]>();

    @Override
    public double getCPUUtilization(String threadId) {
        return this.cpu.getOrDefault(threadId, 0.0);
    }

    @Override
    public double getMajorFault(String threadId) {
        return this.pagingActivities.get(threadId)[0];
    }

    @Override
    public double getMinorFault(String threadId) {
        return this.pagingActivities.get(threadId)[1];
    }

    @Override
    public double getResidentSetSize(String threadId) {
        return this.pagingActivities.get(threadId)[2];
    }

    @Override
    public boolean hasPagingActivity(String threadId) {
        return this.pagingActivities.containsKey(threadId);
    }

    @Override
    public void addSample() {
        this.cpu.clear();
        this.pagingActivities.clear();
        ThreadCPU.INSTANCE.addSample();
    }

    public void setCPUUtilization(String threadId, Double cpuUtilization) {
        this.cpu.put(threadId, cpuUtilization);
    }

    public Set<String> getAllThreadIds() {
        return this.cpu.keySet();
    }

    public void setPagingActivities(String threadId, Double[] activityes) {
        this.pagingActivities.put(threadId, activityes);
    }
}

