/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.handler;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.MetricsRequest;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.grpc.MetricsResponse;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metricsdb.MetricsDB;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import com.google.protobuf.ProtocolStringList;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;

public class MetricsServerHandler {
    private static final Logger LOG = LogManager.getLogger(MetricsServerHandler.class);

    public void collectAPIData(MetricsRequest request, StreamObserver<MetricsResponse> responseObserver) {
        try {
            ReaderMetricsProcessor mp = ReaderMetricsProcessor.getInstance();
            Map.Entry<Long, MetricsDB> dbEntry = mp.getMetricsDB();
            MetricsDB db = dbEntry.getValue();
            Long dbTimestamp = dbEntry.getKey();
            ProtocolStringList metricList = request.getMetricListList();
            ProtocolStringList aggList = request.getAggListList();
            ProtocolStringList dimList = request.getDimListList();
            this.collectStats(db, dbTimestamp, (List<String>)metricList, (List<String>)aggList, (List<String>)dimList, responseObserver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void collectStats(MetricsDB db, Long dbTimestamp, List<String> metricList, List<String> aggList, List<String> dimList, StreamObserver<MetricsResponse> responseObserver) throws Exception {
        Result<Record> metricResult;
        String localResponse = db != null ? ((metricResult = db.queryMetric(metricList, aggList, dimList)) == null ? "{}" : metricResult.formatJSON()) : "{}";
        String localResponseWithTimestamp = String.format("{\"timestamp\": %d, \"data\": %s}", dbTimestamp, localResponse);
        this.sendResponse(localResponseWithTimestamp, responseObserver);
    }

    private void sendResponse(String result, StreamObserver<MetricsResponse> responseObserver) {
        responseObserver.onNext((Object)MetricsResponse.newBuilder().setMetricsResult(result).build());
        responseObserver.onCompleted();
    }
}

