/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatExceptionCode;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.collectors.StatsCollector;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.config.PluginSettings;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.metrics.MetricsConfiguration;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.reader_writer_shared.Event;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class PerformanceAnalyzerMetrics {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerMetrics.class);
    public static final String sDevShmScratchLocation = "performanceanalyzer_scratch";
    public static final String sIndicesPath = "indices";
    public static final String sThreadPoolPath = "thread_pool";
    public static final String sThreadsPath = "threads";
    public static final String sCacheConfigPath = "cache_config";
    public static final String sCircuitBreakerPath = "circuit_breaker";
    public static final String sShardBulkPath = "shardbulk";
    public static final String sShardFetchPath = "shardfetch";
    public static final String sShardQueryPath = "shardquery";
    public static final String sMasterTaskPath = "master_task";
    public static final String sFaultDetection = "fault_detection";
    public static final String sHttpPath = "http";
    public static final String sOSPath = "os_metrics";
    public static final String sHeapPath = "heap_metrics";
    public static final String sNodesPath = "node_metrics";
    public static final String sPendingTasksPath = "pending_tasks";
    public static final String sMasterThrottledTasksPath = "master_throttling_metrics";
    public static final String sShardStatePath = "shard_state_metrics";
    public static final String sDisksPath = "disk_metrics";
    public static final String sTCPPath = "tcp_metrics";
    public static final String sIPPath = "ip_metrics";
    public static final String sGcInfoPath = "gc_info";
    public static final String sMountedPartitionMetricsPath = "mounted_part_space";
    public static final String sKeyValueDelimitor = ":";
    public static final String sMetricNewLineDelimitor = System.getProperty("line.separator");
    public static final String START_FILE_NAME = "start";
    public static final String FINISH_FILE_NAME = "finish";
    public static final String MASTER_CURRENT = "current";
    public static final String MASTER_META_DATA = "metadata";
    public static final String METRIC_CURRENT_TIME = "current_time";
    public static final String FAULT_DETECTION_FOLLOWER_CHECK = "follower_check";
    public static final String FAULT_DETECTION_LEADER_CHECK = "leader_check";
    public static final String FAULT = "fault";
    public static final int QUEUE_SIZE = PluginSettings.instance().getWriterQueueSize();
    public static final BlockingQueue<Event> metricQueue = new ArrayBlockingQueue<Event>(QUEUE_SIZE);
    private static final int NUM_RETRIES_FOR_TMP_FILE = 10;
    private static volatile boolean isMetricsLogEnabled = false;
    private static final int sTimeInterval = MetricsConfiguration.CONFIG_MAP.get(PerformanceAnalyzerMetrics.class).rotationInterval;

    public static long getTimeInterval(long startTime) {
        return PerformanceAnalyzerMetrics.getTimeInterval(startTime, sTimeInterval);
    }

    public static long getTimeInterval(long startTime, int timeInterval) {
        return startTime / (long)timeInterval * (long)timeInterval;
    }

    public static String getCurrentTimeMetric() {
        return "current_time:" + System.currentTimeMillis();
    }

    public static String generatePath(long startTime, String ... keysPath) {
        Path sDevShmLocationPath = Paths.get(PluginSettings.instance().getMetricsLocation(), new String[0]).resolve(Paths.get(String.valueOf(PerformanceAnalyzerMetrics.getTimeInterval(startTime)), keysPath));
        return sDevShmLocationPath.toString();
    }

    public static void setIsMetricsLogEnabled(boolean enabled) {
        isMetricsLogEnabled = enabled;
    }

    public static void addMetricEntry(StringBuilder value, String metricKey, String metricValue) {
        value.append(sMetricNewLineDelimitor).append(metricKey).append(sKeyValueDelimitor).append(metricValue);
    }

    public static void addMetricEntry(StringBuilder value, String metricKey, long metricValue) {
        value.append(sMetricNewLineDelimitor).append(metricKey).append(sKeyValueDelimitor).append(metricValue);
    }

    private static void emitMetric(BlockingQueue<Event> q, Event entry) {
        if (!q.offer(entry)) {
            LOG.debug("Could not enter metric {}", (Object)entry);
        }
    }

    static void emitMetric(long epoch, String metricKey, String value) {
        PerformanceAnalyzerMetrics.emitMetric(metricQueue, new Event(metricKey, value, epoch));
        if (isMetricsLogEnabled) {
            LOG.info(metricKey + "\n" + value);
        }
    }

    public static String getMetric(long startTime, String ... keysPath) {
        return PerformanceAnalyzerMetrics.getMetric(PerformanceAnalyzerMetrics.generatePath(startTime, keysPath));
    }

    public static String getMetric(String keyPath) {
        try {
            return new String(Files.readAllBytes(Paths.get(keyPath, new String[0])));
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String extractMetricValue(String metricVal, String key) {
        int startIndex = metricVal.indexOf(key);
        if (startIndex != -1) {
            int endIndex = metricVal.indexOf(sMetricNewLineDelimitor, (startIndex = metricVal.indexOf(sKeyValueDelimitor, startIndex)) + 1);
            if (endIndex == -1) {
                endIndex = metricVal.length();
            }
            return metricVal.substring(startIndex + 1, endIndex);
        }
        return null;
    }

    public static void removeMetrics(String keyPath) {
        PerformanceAnalyzerMetrics.removeMetrics(new File(keyPath));
    }

    public static void removeMetrics(File keyPathFile) {
        String[] children;
        if (keyPathFile.isDirectory() && (children = keyPathFile.list()) != null) {
            for (String child : children) {
                PerformanceAnalyzerMetrics.removeMetrics(new File(keyPathFile, child));
            }
        }
        try {
            if (!keyPathFile.delete()) {
                LOG.debug("Purge Could not delete file {}", (Object)keyPathFile);
            }
        }
        catch (Exception ex) {
            StatsCollector.instance().logException(StatExceptionCode.METRICS_REMOVE_ERROR);
            LOG.debug(() -> new ParameterizedMessage("Error in deleting file: {} for keyPath:{} with ExceptionCode: {}", new Object[]{ex.toString(), keyPathFile.getAbsolutePath(), StatExceptionCode.METRICS_REMOVE_ERROR.toString()}), (Throwable)ex);
        }
    }

    public static String getJsonCurrentMilliSeconds() {
        return "{\"" + METRIC_CURRENT_TIME + "\"" + sKeyValueDelimitor + System.currentTimeMillis() + "}";
    }
}

