/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.jvm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class GarbageCollectorInfo {
    private static final Map<String, Supplier<String>> gcSuppliers = new HashMap<String, Supplier<String>>();
    private static final ImmutableMap<String, String> memoryPoolMap = ImmutableMap.builder().put((Object)"CMS Perm Gen", (Object)"PermGen").put((Object)"Perm Gen", (Object)"PermGen").put((Object)"PS Perm Gen", (Object)"PermGen").put((Object)"G1 Perm Gen", (Object)"PermGen").put((Object)"Metaspace", (Object)"PermGen").put((Object)"CMS Old Gen", (Object)"OldGen").put((Object)"Tenured Gen", (Object)"OldGen").put((Object)"PS Old Gen", (Object)"OldGen").put((Object)"G1 Old Gen", (Object)"OldGen").put((Object)"Par Eden Space", (Object)"Eden").put((Object)"Eden Space", (Object)"Eden").put((Object)"PS Eden Space", (Object)"Eden").put((Object)"G1 Eden", (Object)"Eden").put((Object)"Par Survivor Space", (Object)"Survivor").put((Object)"Survivor Space", (Object)"Survivor").put((Object)"PS Survivor Space", (Object)"Survivor").put((Object)"G1 Survivor", (Object)"Survivor").build();
    private static final String SURVIVOR = "Survivor";
    private static final String EDEN = "Eden";
    private static final String OLD_GEN = "OldGen";
    private static final String PERM_GEN = "PermGen";

    public static Map<String, Supplier<String>> getGcSuppliers() {
        return gcSuppliers;
    }

    @VisibleForTesting
    public static ImmutableMap<String, String> getMemoryPoolMap() {
        return memoryPoolMap;
    }

    static {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            String[] memoryPools = gcBean.getMemoryPoolNames();
            if (memoryPools == null || memoryPools.length <= 0) continue;
            for (String memoryPool : memoryPools) {
                String genericMemoryPool = (String)memoryPoolMap.getOrDefault((Object)memoryPool, (Object)memoryPool);
                gcSuppliers.putIfAbsent(genericMemoryPool, gcBean::getName);
            }
        }
    }
}

