/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen;

import com.amazon.opendistro.elasticsearch.performanceanalyzer.AppContext;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.actions.Action;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.DecisionPolicy;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.LevelOneActionBuilder;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.LevelThreeActionBuilder;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen.LevelTwoActionBuilder;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.framework.core.RcaConf;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import com.amazon.opendistro.elasticsearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OldGenDecisionPolicy
implements DecisionPolicy {
    private static final Logger LOG = LogManager.getLogger(OldGenDecisionPolicy.class);
    private AppContext appContext;
    private RcaConf rcaConf;
    private final HighHeapUsageClusterRca highHeapUsageClusterRca;

    public OldGenDecisionPolicy(HighHeapUsageClusterRca highHeapUsageClusterRca) {
        this.highHeapUsageClusterRca = highHeapUsageClusterRca;
    }

    public void setRcaConf(RcaConf rcaConf) {
        this.rcaConf = rcaConf;
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public List<Action> evaluate() {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.highHeapUsageClusterRca.getFlowUnits().isEmpty()) {
            return actions;
        }
        ResourceFlowUnit flowUnit = (ResourceFlowUnit)this.highHeapUsageClusterRca.getFlowUnits().get(0);
        if (!flowUnit.hasResourceSummary()) {
            return actions;
        }
        HotClusterSummary clusterSummary = (HotClusterSummary)flowUnit.getSummary();
        for (HotNodeSummary nodeSummary : clusterSummary.getHotNodeSummaryList()) {
            NodeKey esNode = new NodeKey(nodeSummary.getNodeID(), nodeSummary.getHostAddress());
            for (HotResourceSummary resource : nodeSummary.getHotResourceSummaryList()) {
                if (!resource.getResource().equals(ResourceUtil.OLD_GEN_HEAP_USAGE)) continue;
                actions.addAll(this.evaluate(esNode, resource.getValue()));
            }
        }
        return actions;
    }

    private List<Action> evaluate(NodeKey esNode, double oldGenUsage) {
        if (this.rcaConf == null || this.appContext == null) {
            LOG.error("rca conf/app context is null, return empty action list");
            return new ArrayList<Action>();
        }
        OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig = this.rcaConf.getDeciderConfig().getOldGenDecisionPolicyConfig();
        if (oldGenUsage >= oldGenDecisionPolicyConfig.oldGenThresholdLevelThree()) {
            return LevelThreeActionBuilder.newBuilder(esNode, this.appContext, this.rcaConf).build();
        }
        if (oldGenUsage >= oldGenDecisionPolicyConfig.oldGenThresholdLevelTwo()) {
            return LevelTwoActionBuilder.newBuilder(esNode, this.appContext, this.rcaConf).build();
        }
        if (oldGenUsage >= oldGenDecisionPolicyConfig.oldGenThresholdLevelOne()) {
            return LevelOneActionBuilder.newBuilder(esNode, this.appContext, this.rcaConf).build();
        }
        return new ArrayList<Action>();
    }
}

